/*
 * Decompiled with CFR 0.152.
 */
package com.github.pfmiles.dropincc.impl.syntactical.codegen;

import com.github.pfmiles.dropincc.DropinccException;
import com.github.pfmiles.dropincc.impl.syntactical.codegen.CodeGenContext;
import com.github.pfmiles.dropincc.impl.util.ByteAppender;
import java.io.IOException;
import java.io.InputStream;

public abstract class CodeGen {
    protected static String getTemplate(String name, Class<? extends CodeGen> cls) {
        return CodeGen.readStrStream(cls.getResourceAsStream(name));
    }

    private static String readStrStream(InputStream stm) {
        if (stm == null) {
            return null;
        }
        ByteAppender ba = new ByteAppender();
        byte[] buf = new byte[1024];
        int count = 0;
        try {
            count = stm.read(buf);
            while (count != -1) {
                ba.append(buf, 0, count);
                count = stm.read(buf);
            }
            return new String(ba.toByteArray(), "UTF-8");
        }
        catch (IOException e) {
            throw new DropinccException(e);
        }
    }

    public abstract <T> T render(CodeGenContext var1);
}

