/*
 * Decompiled with CFR 0.152.
 */
package com.github.pfmiles.dropincc.impl.syntactical.codegen;

import com.github.pfmiles.dropincc.Action;
import com.github.pfmiles.dropincc.DropinccException;
import com.github.pfmiles.dropincc.ParamedAction;
import com.github.pfmiles.dropincc.impl.GruleType;
import com.github.pfmiles.dropincc.impl.syntactical.codegen.CodeGen;
import com.github.pfmiles.dropincc.impl.syntactical.codegen.CodeGenContext;
import java.text.MessageFormat;
import java.util.List;

public class AltsActionsGen
extends CodeGen {
    private static final String fmt = "public {0} {1}Action{2};// {1} rule alt {2} action";
    private List<Object[]> actionInfos;

    public AltsActionsGen(List<Object[]> actionInfos) {
        this.actionInfos = actionInfos;
    }

    public String render(CodeGenContext context) {
        StringBuilder sb = new StringBuilder();
        for (Object[] actionInfo : this.actionInfos) {
            Object action = actionInfo[2];
            String actionCls = null;
            if (action instanceof Action) {
                actionCls = "Action";
            } else if (action instanceof ParamedAction) {
                actionCls = "ParamedAction";
            } else {
                throw new DropinccException("Invalid action object: " + action);
            }
            String ruleName = ((GruleType)actionInfo[0]).toCodeGenStr();
            String altIndex = String.valueOf(actionInfo[1]);
            String fname = ruleName + "Action" + altIndex;
            context.fieldAltsActionMapping.put(fname, action);
            context.actionFieldMapping.put(action, fname);
            sb.append(MessageFormat.format(fmt, actionCls, ruleName, altIndex)).append("\n");
        }
        return sb.toString();
    }
}

