/*
 * Decompiled with CFR 0.152.
 */
package com.github.pfmiles.dropincc.impl.syntactical;

import com.github.pfmiles.dropincc.CC;
import com.github.pfmiles.dropincc.DropinccException;
import com.github.pfmiles.dropincc.Element;
import com.github.pfmiles.dropincc.Grule;
import com.github.pfmiles.dropincc.TokenDef;
import com.github.pfmiles.dropincc.impl.Alternative;
import com.github.pfmiles.dropincc.impl.AndSubRule;
import com.github.pfmiles.dropincc.impl.CAlternative;
import com.github.pfmiles.dropincc.impl.ConstructingGrule;
import com.github.pfmiles.dropincc.impl.EleType;
import com.github.pfmiles.dropincc.impl.GruleType;
import com.github.pfmiles.dropincc.impl.OrSubRule;
import com.github.pfmiles.dropincc.impl.SpecialType;
import com.github.pfmiles.dropincc.impl.TokenType;
import com.github.pfmiles.dropincc.impl.TypeMappingParam;
import com.github.pfmiles.dropincc.impl.kleene.AbstractKleeneNode;
import com.github.pfmiles.dropincc.impl.kleene.KleeneStarType;
import com.github.pfmiles.dropincc.impl.kleene.KleeneType;
import com.github.pfmiles.dropincc.impl.kleene.OptionalType;
import com.github.pfmiles.dropincc.impl.llstar.GenedKleeneGruleType;
import com.github.pfmiles.dropincc.impl.llstar.LlstarAnalysis;
import com.github.pfmiles.dropincc.impl.llstar.PredictingGrule;
import com.github.pfmiles.dropincc.impl.llstar.PredictingKleene;
import com.github.pfmiles.dropincc.impl.syntactical.GenedGrule;
import com.github.pfmiles.dropincc.impl.syntactical.GenedGruleType;
import com.github.pfmiles.dropincc.impl.syntactical.PredictingResult;
import com.github.pfmiles.dropincc.impl.syntactical.codegen.AltsActionsGen;
import com.github.pfmiles.dropincc.impl.syntactical.codegen.CodeGenContext;
import com.github.pfmiles.dropincc.impl.syntactical.codegen.KleeneDfasGen;
import com.github.pfmiles.dropincc.impl.syntactical.codegen.ParserClsGen;
import com.github.pfmiles.dropincc.impl.syntactical.codegen.ParserCodeGenResult;
import com.github.pfmiles.dropincc.impl.syntactical.codegen.PredsGen;
import com.github.pfmiles.dropincc.impl.syntactical.codegen.RuleDfasGen;
import com.github.pfmiles.dropincc.impl.syntactical.codegen.RuleMethodsGen;
import com.github.pfmiles.dropincc.impl.syntactical.codegen.TokenTypesGen;
import com.github.pfmiles.dropincc.impl.util.Pair;
import com.github.pfmiles.dropincc.impl.util.SeqGen;
import com.github.pfmiles.dropincc.impl.util.SetStack;
import com.github.pfmiles.dropincc.impl.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class ParserCompiler {
    public static List<Grule> rewriteSubRules(List<Grule> grules) {
        if (grules != null && !grules.isEmpty()) {
            ArrayList<Grule> genGrules = new ArrayList<Grule>();
            HashSet<Grule> examinedGrules = new HashSet<Grule>();
            for (Grule g : grules) {
                ParserCompiler.rewriteSubRulesForGrule(g, examinedGrules, genGrules);
            }
            return genGrules;
        }
        throw new DropinccException("No grammar rules defined, error!");
    }

    private static void rewriteSubRulesForGrule(Grule g, Set<Grule> examinedGrules, List<Grule> genGrules) {
        if (examinedGrules.contains(g)) {
            return;
        }
        examinedGrules.add(g);
        for (Alternative alt : g.getAlts()) {
            ParserCompiler.rewriteSubRuleForElements(alt.getElements(), examinedGrules, genGrules);
        }
    }

    private static void rewriteSubRuleForElements(List<Element> eles, Set<Grule> examinedGrules, List<Grule> genGrules) {
        ListIterator<Element> iter = eles.listIterator();
        while (iter.hasNext()) {
            GenedGrule genGrule;
            Element e = iter.next();
            Class<?> eleCls = e.getClass();
            if (AndSubRule.class.isAssignableFrom(eleCls)) {
                iter.remove();
                AndSubRule asr = (AndSubRule)e;
                genGrule = new GenedGrule();
                List<Alternative> asrAlts = asr.getAlts();
                genGrule.setAlts(asrAlts);
                iter.add(genGrule);
                genGrules.add(genGrule);
                for (Alternative alt : asrAlts) {
                    ParserCompiler.rewriteSubRuleForElements(alt.getElements(), examinedGrules, genGrules);
                }
                continue;
            }
            if (OrSubRule.class.isAssignableFrom(eleCls)) {
                iter.remove();
                OrSubRule osr = (OrSubRule)e;
                genGrule = new GenedGrule();
                List<Alternative> osrAlts = osr.getAlts();
                genGrule.setAlts(osrAlts);
                iter.add(genGrule);
                genGrules.add(genGrule);
                for (Alternative alt : osrAlts) {
                    ParserCompiler.rewriteSubRuleForElements(alt.getElements(), examinedGrules, genGrules);
                }
                continue;
            }
            if (ConstructingGrule.class.isAssignableFrom(eleCls)) {
                throw new DropinccException("Something must be wrong, ConstructingGrule shouldn't appear here");
            }
            if (Grule.class.isAssignableFrom(eleCls)) {
                ParserCompiler.rewriteSubRulesForGrule((Grule)e, examinedGrules, genGrules);
                continue;
            }
            if (TokenDef.class.isAssignableFrom(eleCls) || CC.NOTHING.equals(e)) continue;
            if (AbstractKleeneNode.class.isAssignableFrom(eleCls)) {
                ParserCompiler.rewriteSubRuleForElements(((AbstractKleeneNode)e).getElements(), examinedGrules, genGrules);
                continue;
            }
            throw new DropinccException("Unhandled element: " + e);
        }
    }

    public static Map<Grule, GruleType> buildGruleTypeMapping(List<Grule> grules, List<Grule> genGrules) {
        LinkedHashMap<Grule, GruleType> gruleTypeMapping = new LinkedHashMap<Grule, GruleType>();
        if (grules != null && !grules.isEmpty()) {
            for (int i = 0; i < grules.size(); ++i) {
                gruleTypeMapping.put(grules.get(i), new GruleType(i));
            }
            if (genGrules.size() != 0) {
                int base = grules.size();
                for (int i = 0; i < genGrules.size(); ++i) {
                    gruleTypeMapping.put(genGrules.get(i), new GenedGruleType(base + i));
                }
            }
        } else {
            throw new DropinccException("No grammar rules defined, error!");
        }
        return gruleTypeMapping;
    }

    public static Map<GruleType, List<CAlternative>> buildRuleTypeToAlts(TypeMappingParam param) {
        HashMap<GruleType, List<CAlternative>> ruleTypeToAlts = new HashMap<GruleType, List<CAlternative>>();
        for (Map.Entry<Grule, GruleType> entry : param.getGruleTypeMapping().entrySet()) {
            ruleTypeToAlts.put(entry.getValue(), ParserCompiler.resolveCAlts(entry.getKey().getAlts(), param));
        }
        return ruleTypeToAlts;
    }

    private static List<CAlternative> resolveCAlts(List<Alternative> alts, TypeMappingParam param) {
        ArrayList<CAlternative> ret = new ArrayList<CAlternative>();
        for (Alternative a : alts) {
            List<EleType> ms = ParserCompiler.eleListToTypeList(a.getElements(), param);
            ret.add(new CAlternative(ms, a.getAction(), a.getPred()));
        }
        return ret;
    }

    private static List<EleType> eleListToTypeList(List<Element> eles, TypeMappingParam param) {
        ArrayList<EleType> ret = new ArrayList<EleType>();
        for (Element e : eles) {
            EleType t = Util.resolveEleType(e, param);
            if (t == null) {
                throw new DropinccException("Could not resolve element type for element: " + e + ", is this element defined in a proper manner?");
            }
            ret.add(t);
        }
        return ret;
    }

    public static void checkAndReportLeftRecursions(Map<GruleType, List<CAlternative>> ruleTypeToAlts, Map<KleeneType, List<EleType>> kleeneTypeToNode) {
        SetStack<GruleType> path = new SetStack<GruleType>();
        for (Map.Entry<GruleType, List<CAlternative>> e : ruleTypeToAlts.entrySet()) {
            ParserCompiler.examineEleType(e.getKey(), path, ruleTypeToAlts, kleeneTypeToNode);
        }
    }

    private static void examineEleType(EleType t, SetStack<GruleType> path, Map<GruleType, List<CAlternative>> ruleTypeToAlts, Map<KleeneType, List<EleType>> kleeneTypeToNode) {
        if (t instanceof SpecialType) {
            return;
        }
        if (t instanceof TokenType) {
            return;
        }
        if (t instanceof GruleType) {
            if (path.contains(t)) {
                throw new DropinccException("Left recursion detected: " + Util.dumpCirclePath(path, t));
            }
            path.push((GruleType)t);
            List<CAlternative> alts = ruleTypeToAlts.get(t);
            block0: for (CAlternative a : alts) {
                for (EleType ele : a.getMatchSequence()) {
                    ParserCompiler.examineEleType(ele, path, ruleTypeToAlts, kleeneTypeToNode);
                    if (ele instanceof KleeneStarType || ele instanceof OptionalType) continue;
                    continue block0;
                }
            }
            path.pop();
        } else if (t instanceof KleeneType) {
            List<EleType> knode = kleeneTypeToNode.get(t);
            for (EleType ele : knode) {
                ParserCompiler.examineEleType(ele, path, ruleTypeToAlts, kleeneTypeToNode);
                if (ele instanceof KleeneStarType || ele instanceof OptionalType) continue;
                break;
            }
        } else {
            throw new DropinccException("Unhandled element type: " + t);
        }
    }

    public static PredictingResult computePredictingGrules(Map<GruleType, List<CAlternative>> ruleTypeToAlts, Map<KleeneType, List<EleType>> kleeneTypeToNode) {
        ArrayList<PredictingGrule> pgs = new ArrayList<PredictingGrule>();
        LlstarAnalysis a = new LlstarAnalysis(ruleTypeToAlts, kleeneTypeToNode);
        Set<GruleType> nonLLRegularGrules = a.getNonLLRegularGrules();
        Set<KleeneType> nonLLRegularKleenes = a.getNonLLRegularKleenes();
        Set<GruleType> gtypeOnBacktrackPath = ParserCompiler.findNodesOnBacktrackingPath(nonLLRegularGrules, nonLLRegularKleenes, ruleTypeToAlts, kleeneTypeToNode);
        for (Map.Entry<GruleType, List<CAlternative>> e : ruleTypeToAlts.entrySet()) {
            GruleType grule = e.getKey();
            if (nonLLRegularGrules.contains(grule)) {
                pgs.add(new PredictingGrule(grule, e.getValue(), gtypeOnBacktrackPath.contains(grule)));
                continue;
            }
            pgs.add(new PredictingGrule(grule, a.getLookAheadDfa(grule), e.getValue(), gtypeOnBacktrackPath.contains(grule)));
        }
        ArrayList<PredictingKleene> pks = new ArrayList<PredictingKleene>();
        for (Map.Entry<KleeneType, List<EleType>> e : kleeneTypeToNode.entrySet()) {
            KleeneType ktype = e.getKey();
            if (nonLLRegularKleenes.contains(ktype)) {
                pks.add(new PredictingKleene(ktype, e.getValue()));
                continue;
            }
            pks.add(new PredictingKleene(ktype, a.getKleenDfaMapping().get(ktype), e.getValue()));
        }
        return new PredictingResult(pgs, pks, a.getDebugMsg(), a.getWarnings());
    }

    private static Set<GruleType> findNodesOnBacktrackingPath(Set<GruleType> backtrackGrules, Set<KleeneType> backtrackKleenes, Map<GruleType, List<CAlternative>> ruleTypeToAlts, Map<KleeneType, List<EleType>> kleeneTypeToNode) {
        HashSet<GruleType> onPathGrules = new HashSet<GruleType>();
        HashSet<GruleType> examinedGrules = new HashSet<GruleType>();
        HashSet<KleeneType> examinedKleenes = new HashSet<KleeneType>();
        if (backtrackGrules != null) {
            for (GruleType g : backtrackGrules) {
                if (!g.getClass().equals(GruleType.class)) continue;
                examinedGrules.add(g);
                for (CAlternative alt : ruleTypeToAlts.get(g)) {
                    ParserCompiler.markBacktrackPathForElements(alt.getMatchSequence(), onPathGrules, ruleTypeToAlts, kleeneTypeToNode, examinedGrules, examinedKleenes);
                }
            }
        }
        if (backtrackKleenes != null) {
            for (KleeneType k : backtrackKleenes) {
                examinedKleenes.add(k);
                ParserCompiler.markBacktrackPathForElements(kleeneTypeToNode.get(k), onPathGrules, ruleTypeToAlts, kleeneTypeToNode, examinedGrules, examinedKleenes);
            }
        }
        return onPathGrules;
    }

    private static void markBacktrackPathForElements(List<EleType> matchSequence, Set<GruleType> onPathGrules, Map<GruleType, List<CAlternative>> ruleTypeToAlts, Map<KleeneType, List<EleType>> kleeneTypeToNode, Set<GruleType> examinedGrules, Set<KleeneType> examinedKleenes) {
        for (EleType ele : matchSequence) {
            KleeneType k;
            if (ele instanceof GruleType) {
                GruleType g = (GruleType)ele;
                onPathGrules.add(g);
                if (examinedGrules.contains(g)) continue;
                examinedGrules.add(g);
                for (CAlternative alt : ruleTypeToAlts.get(g)) {
                    ParserCompiler.markBacktrackPathForElements(alt.getMatchSequence(), onPathGrules, ruleTypeToAlts, kleeneTypeToNode, examinedGrules, examinedKleenes);
                }
                continue;
            }
            if (!(ele instanceof KleeneType) || examinedKleenes.contains(k = (KleeneType)ele)) continue;
            examinedKleenes.add(k);
            ParserCompiler.markBacktrackPathForElements(kleeneTypeToNode.get(k), onPathGrules, ruleTypeToAlts, kleeneTypeToNode, examinedGrules, examinedKleenes);
        }
    }

    public static ParserCodeGenResult genParserCode(String parserName, GruleType startRule, List<PredictingGrule> predGrules, List<PredictingKleene> pks, Collection<TokenType> tokenTypes, Map<KleeneType, List<EleType>> kleeneTypeToNode) {
        TokenTypesGen tokenTypesGen = new TokenTypesGen(tokenTypes);
        ArrayList<Object[]> actionInfos = new ArrayList<Object[]>();
        ArrayList<Object[]> predInfos = new ArrayList<Object[]>();
        for (PredictingGrule pg : predGrules) {
            GruleType grule = pg.getGruleType();
            for (int i = 0; i < pg.getAlts().size(); ++i) {
                CAlternative calt = pg.getAlts().get(i);
                if (calt.getAction() != null) {
                    actionInfos.add(new Object[]{grule, i, calt.getAction()});
                }
                if (calt.getPredicate() == null) continue;
                predInfos.add(new Object[]{grule, i, calt.getPredicate()});
            }
        }
        AltsActionsGen actionsGen = new AltsActionsGen(actionInfos);
        PredsGen predsGen = new PredsGen(predInfos);
        RuleDfasGen ruleDfaGen = new RuleDfasGen(predGrules);
        KleeneDfasGen kleeneDfas = new KleeneDfasGen(pks);
        RuleMethodsGen ruleMethodsGen = new RuleMethodsGen(predGrules);
        ParserClsGen parserGen = new ParserClsGen(parserName, tokenTypesGen, actionsGen, predsGen, ruleDfaGen, kleeneDfas, startRule, ruleMethodsGen);
        CodeGenContext ctx = new CodeGenContext(ParserCompiler.resolveKleenePredictingMapping(pks));
        return new ParserCodeGenResult(parserGen.render(ctx), ctx);
    }

    private static Map<KleeneType, PredictingKleene> resolveKleenePredictingMapping(List<PredictingKleene> pks) {
        HashMap<KleeneType, PredictingKleene> ret = new HashMap<KleeneType, PredictingKleene>();
        for (PredictingKleene pk : pks) {
            ret.put(pk.getKleeneType(), pk);
        }
        return ret;
    }

    public static Pair<Map<GruleType, List<CAlternative>>, Map<KleeneType, GenedKleeneGruleType>> genAnalyzingGrulesForKleenes(Map<KleeneType, List<EleType>> kleeneTypeToNode, int base) {
        HashMap genedGrules = new HashMap();
        HashMap<KleeneType, GenedKleeneGruleType> kleeneToGenedGrule = new HashMap<KleeneType, GenedKleeneGruleType>();
        SeqGen seq = new SeqGen(base);
        for (Map.Entry<KleeneType, List<EleType>> e : kleeneTypeToNode.entrySet()) {
            ArrayList<CAlternative> alts = new ArrayList<CAlternative>();
            alts.add(new CAlternative(e.getValue(), null, null));
            alts.add(new CAlternative(Collections.<EleType>emptyList(), null, null));
            GenedKleeneGruleType gt = new GenedKleeneGruleType(seq.next());
            genedGrules.put(gt, alts);
            kleeneToGenedGrule.put(e.getKey(), gt);
        }
        return new Pair<Map<GruleType, List<CAlternative>>, Map<KleeneType, GenedKleeneGruleType>>(genedGrules, kleeneToGenedGrule);
    }
}

