/*
 * Decompiled with CFR 0.152.
 */
package com.github.pfmiles.dropincc.impl.runtime.impl;

import com.github.pfmiles.dropincc.DropinccException;
import com.github.pfmiles.dropincc.impl.TokenType;
import com.github.pfmiles.dropincc.impl.runtime.Token;
import com.github.pfmiles.dropincc.impl.runtime.impl.CodeLexer;
import com.github.pfmiles.dropincc.impl.runtime.impl.DelayedAction;
import com.github.pfmiles.dropincc.impl.runtime.impl.Lexer;
import com.github.pfmiles.dropincc.impl.runtime.impl.ParseCacheKey;
import com.github.pfmiles.dropincc.impl.runtime.impl.Parser;
import com.github.pfmiles.dropincc.impl.util.Pair;
import java.util.HashMap;
import java.util.Map;

public abstract class CodeParser
extends Parser
implements Cloneable {
    protected CodeLexer lexer;
    private Map<ParseCacheKey, Pair<DelayedAction, Integer>> parseCache = new HashMap<ParseCacheKey, Pair<DelayedAction, Integer>>();
    private int lastForwardPosition = -1;

    protected void putInCache(int ruleNum, DelayedAction node, int startPoint) {
        int forwardPosition = this.lexer.getCurrentPosition();
        this.parseCache.put(new ParseCacheKey(ruleNum, startPoint), new Pair<DelayedAction, Integer>(node, forwardPosition));
    }

    protected DelayedAction tryResolveFromCache(int ruleNum) {
        ParseCacheKey k = new ParseCacheKey(ruleNum, this.lexer.getCurrentPosition());
        if (this.parseCache.containsKey(k)) {
            Pair<DelayedAction, Integer> p = this.parseCache.get(k);
            this.lastForwardPosition = p.getRight();
            return p.getLeft();
        }
        return null;
    }

    protected Object match(TokenType type) {
        Token ret = this.lexer.nextElement();
        if (!ret.getType().equals(type)) {
            throw new DropinccException("Unexpected token encountered: " + ret + ", expected type: " + type + ", at position: " + this.lexer.getCurrentPosition());
        }
        return ret.getLexeme();
    }

    protected void fastForward() {
        this.lexer.fastForward(this.lastForwardPosition);
    }

    @Override
    public void setLexer(Lexer lexer) {
        this.lexer = (CodeLexer)lexer;
    }

    protected void cleanCache() {
        if (!this.parseCache.isEmpty()) {
            this.parseCache.clear();
        }
    }

    protected DelayedAction newDelayedAction(Object action, Object matched) {
        if (matched instanceof DelayedAction) {
            DelayedAction da = (DelayedAction)matched;
            if (action == null) {
                return da;
            }
            if (da.action == null) {
                da.action = action;
                return da;
            }
        }
        return new DelayedAction(action, matched);
    }

    protected CodeParser clone() {
        CodeParser ret = null;
        try {
            ret = (CodeParser)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new DropinccException(e);
        }
        ret.parseCache = new HashMap<ParseCacheKey, Pair<DelayedAction, Integer>>();
        return ret;
    }
}

