/*
 * Decompiled with CFR 0.152.
 */
package com.github.pfmiles.dropincc.impl.runtime.impl;

import com.github.pfmiles.dropincc.DropinccException;
import com.github.pfmiles.dropincc.impl.TokenType;
import com.github.pfmiles.dropincc.impl.runtime.Token;
import com.github.pfmiles.dropincc.impl.runtime.impl.Lexer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CodeLexer
extends Lexer {
    private Map<Integer, TokenType> groupNumToType;
    private String code = null;
    private Matcher matcher = null;
    private int currentRealPos = 0;
    private boolean eofReturned = false;
    private boolean whiteSpaceSensitive;
    private Deque<Integer[]> savePoints = new ArrayDeque<Integer[]>();
    private ArrayList<Token> backUp = new ArrayList();

    public CodeLexer(Pattern pattern, Map<Integer, TokenType> groupNumToType, String code, boolean whiteSpaceSensitive) {
        this.groupNumToType = groupNumToType;
        this.code = code;
        this.matcher = pattern.matcher(code);
        this.whiteSpaceSensitive = whiteSpaceSensitive;
    }

    @Override
    public boolean hasMoreElements() {
        if (!this.lookAheadBuf.isEmpty() || this.currentRealPos < this.code.length()) {
            return true;
        }
        return !this.eofReturned;
    }

    @Override
    public Token nextElement() {
        Token ret = null;
        if (!this.lookAheadBuf.isEmpty()) {
            ret = (Token)this.lookAheadBuf.remove(0);
            this.allBufferedLexemeLength -= ret.getLength();
        } else {
            ret = this.realNext();
        }
        if (ret == null) {
            throw new DropinccException("No more token.");
        }
        if (!this.savePoints.isEmpty()) {
            this.backUp.add(ret);
        }
        return ret;
    }

    @Override
    protected Token realNext() {
        Token t = this._realNext();
        if (!this.whiteSpaceSensitive) {
            while (t != null && t.getType().equals(TokenType.WHITESPACE)) {
                t = this._realNext();
            }
        }
        return t;
    }

    private Token _realNext() {
        if (this.currentRealPos < this.code.length()) {
            if (this.matcher.find(this.currentRealPos)) {
                for (Map.Entry<Integer, TokenType> e : this.groupNumToType.entrySet()) {
                    String txt;
                    int gnum = e.getKey();
                    if (gnum == -1 || (txt = this.matcher.group(gnum)) == null) continue;
                    int length = this.matcher.end() - this.matcher.start();
                    this.currentRealPos += length;
                    return new Token(e.getValue(), txt, length);
                }
                throw new DropinccException("No token matched at position: " + this.currentRealPos + ", subsequent char: '" + this.code.charAt(this.currentRealPos) + "'");
            }
            throw new DropinccException("Unexpected char: '" + this.code.charAt(this.currentRealPos) + "' at position: " + this.currentRealPos);
        }
        if (!this.eofReturned) {
            this.eofReturned = true;
            return Token.EOF;
        }
        return null;
    }

    @Override
    public int getCurrentPosition() {
        return this.currentRealPos - this.allBufferedLexemeLength;
    }

    public void setSavePoint(int ruleNum) {
        this.savePoints.push(new Integer[]{ruleNum, this.backUp.size(), this.getCurrentPosition()});
    }

    public int releaseSavePoint(int ruleNum, boolean success) {
        Integer[] top = this.savePoints.pop();
        if (top[0] != ruleNum) {
            throw new RuntimeException("Fatal Error! Rule number doesn't match when releasing save point!");
        }
        if (!success) {
            List<Token> sub = this.backUp.subList(top[1], this.backUp.size());
            this.lookAheadBuf.addAll(0, sub);
            for (Token t : sub) {
                this.allBufferedLexemeLength += t.getLength();
            }
            sub.clear();
        } else if (this.savePoints.isEmpty() && !this.backUp.isEmpty()) {
            this.backUp.clear();
        }
        return top[2];
    }

    public boolean isBacktracking() {
        return !this.savePoints.isEmpty();
    }

    public void fastForward(int position) {
        int chars = position - this.getCurrentPosition();
        if (chars < 0) {
            throw new RuntimeException("Illegal fast forward operation, the target position is before the current position!");
        }
        while (chars > 0) {
            chars -= this.nextElement().getLength();
        }
        if (chars < 0) {
            throw new RuntimeException("Illegal fast forward operation, failed to forward to the proper position!");
        }
    }
}

