/*
 * Decompiled with CFR 0.152.
 */
package com.github.pfmiles.dropincc.impl.llstar;

import com.github.pfmiles.dropincc.DropinccException;
import com.github.pfmiles.dropincc.impl.llstar.AtnConfig;
import com.github.pfmiles.dropincc.impl.llstar.AtnState;
import com.github.pfmiles.dropincc.impl.llstar.DfaState;
import com.github.pfmiles.dropincc.impl.util.SeqGen;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LookAheadDfa {
    private Set<DfaState> states = new HashSet<DfaState>();
    private Map<Integer, DfaState> finalStates = new HashMap<Integer, DfaState>();
    private SeqGen dfaStatesSeq = new SeqGen();
    private DfaState start;

    public DfaState getStart() {
        return this.start;
    }

    public void setStart(DfaState start) {
        if (this.start != null) {
            throw new DropinccException("A look-ahead dfa could have only one start state!");
        }
        this.start = start;
    }

    public void removeStates(Collection<DfaState> tbds) {
        this.states.removeAll(tbds);
    }

    public void addState(DfaState state) {
        state.setName("d" + this.dfaStatesSeq.next());
        this.states.add(state);
    }

    public boolean containState(DfaState s) {
        return this.states.contains(s);
    }

    public void addDummyFinalState(int alt) {
        DfaState state = new DfaState();
        state.addConf(new AtnConfig(new AtnState("_dummy_final_" + alt), alt));
        state.setAlt(alt);
        state.setStopTransit(true);
        this.addState(state);
        this.finalStates.put(alt, state);
    }

    public DfaState overrideFinalState(int alt, DfaState state) {
        DfaState oldFinal = this.finalStates.put(alt, state);
        for (DfaState s : this.states) {
            for (Map.Entry<Object, DfaState> trans : s.getTransitions().entrySet()) {
                if (!trans.getValue().equals(oldFinal)) continue;
                trans.setValue(state);
            }
        }
        if (!oldFinal.equals(state)) {
            this.states.remove(oldFinal);
        }
        return oldFinal;
    }

    public String toString() {
        return this.states.toString();
    }

    public String toDot() {
        return this.toString();
    }

    public DfaState getSameState(DfaState state) {
        if (!this.states.contains(state)) {
            return null;
        }
        for (DfaState s : this.states) {
            if (!s.equals(state)) continue;
            return s;
        }
        throw new DropinccException("Impossible!");
    }

    public DfaState getFinalStateOfAlt(int alt) {
        return this.finalStates.get(alt);
    }

    public Set<DfaState> getStates() {
        return this.states;
    }
}

