/*
 * Decompiled with CFR 0.152.
 */
package com.github.pfmiles.dropincc.impl.llstar;

import com.github.pfmiles.dropincc.DropinccException;
import com.github.pfmiles.dropincc.Predicate;
import com.github.pfmiles.dropincc.impl.CAlternative;
import com.github.pfmiles.dropincc.impl.EleType;
import com.github.pfmiles.dropincc.impl.GruleType;
import com.github.pfmiles.dropincc.impl.TokenType;
import com.github.pfmiles.dropincc.impl.kleene.KleeneCrossType;
import com.github.pfmiles.dropincc.impl.kleene.KleeneStarType;
import com.github.pfmiles.dropincc.impl.kleene.KleeneType;
import com.github.pfmiles.dropincc.impl.kleene.OptionalType;
import com.github.pfmiles.dropincc.impl.llstar.Atn;
import com.github.pfmiles.dropincc.impl.llstar.AtnConfig;
import com.github.pfmiles.dropincc.impl.llstar.AtnState;
import com.github.pfmiles.dropincc.impl.llstar.CallStack;
import com.github.pfmiles.dropincc.impl.llstar.Constants;
import com.github.pfmiles.dropincc.impl.llstar.DfaState;
import com.github.pfmiles.dropincc.impl.llstar.GenedKleeneGruleType;
import com.github.pfmiles.dropincc.impl.llstar.LookAheadDfa;
import com.github.pfmiles.dropincc.impl.llstar.NonLlRegularException;
import com.github.pfmiles.dropincc.impl.syntactical.ParserCompiler;
import com.github.pfmiles.dropincc.impl.util.Pair;
import com.github.pfmiles.dropincc.impl.util.Util;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LlstarAnalysis {
    private StringBuilder warnings = new StringBuilder();
    private StringBuilder debugMsg = new StringBuilder();
    private Atn atn;
    private Map<GruleType, LookAheadDfa> gruleDfaMapping = new HashMap<GruleType, LookAheadDfa>();
    private Map<KleeneType, LookAheadDfa> kleenDfaMapping = new HashMap<KleeneType, LookAheadDfa>();
    private Set<GruleType> nonLLRegularGrules = new HashSet<GruleType>();
    private Set<KleeneType> nonLLRegularKleenes = new HashSet<KleeneType>();

    public LlstarAnalysis(Map<GruleType, List<CAlternative>> ruleTypeToAltsOriginal, Map<KleeneType, List<EleType>> kleeneTypeToNode) {
        LookAheadDfa dfa;
        GruleType grule;
        HashMap<GruleType, List<CAlternative>> ruleTypeToAlts = new HashMap<GruleType, List<CAlternative>>(ruleTypeToAltsOriginal);
        Pair<Map<GruleType, List<CAlternative>>, Map<KleeneType, GenedKleeneGruleType>> genedGruleAndMapping = ParserCompiler.genAnalyzingGrulesForKleenes(kleeneTypeToNode, ruleTypeToAltsOriginal.size());
        ruleTypeToAlts.putAll(genedGruleAndMapping.getLeft());
        Map<KleeneType, GenedKleeneGruleType> kleeneGenedGruleMapping = genedGruleAndMapping.getRight();
        HashMap<KleeneType, AtnState> contactPoints = new HashMap<KleeneType, AtnState>();
        this.atn = new Atn();
        for (Map.Entry entry : ruleTypeToAlts.entrySet()) {
            grule = (GruleType)entry.getKey();
            List calts = (List)entry.getValue();
            AtnState pa = this.atn.newStartStateForGrule(grule);
            AtnState pa1 = this.atn.newEndStateForGrule(grule);
            for (int i = 0; i < calts.size(); ++i) {
                CAlternative calt = (CAlternative)calts.get(i);
                List<EleType> alt = calt.getMatchSequence();
                AtnState pai = this.atn.newAltStateForGrule(grule, i);
                pa.addTransition(Constants.epsilon, pai);
                if (alt != null && !alt.isEmpty()) {
                    AtnState p0 = this.atn.newAtnState(grule);
                    Predicate<?> pred = calt.getPredicate();
                    if (pred != null) {
                        pai.addTransition(pred, p0);
                    } else {
                        pai.addTransition(Constants.epsilon, p0);
                    }
                    AtnState curState = p0;
                    for (EleType edge : alt) {
                        AtnState nextState;
                        List<EleType> contents;
                        if (edge instanceof TokenType || edge instanceof GruleType) {
                            AtnState nextState2 = this.atn.newAtnState(grule);
                            curState.addTransition(edge, nextState2);
                            curState = nextState2;
                            continue;
                        }
                        if (edge instanceof KleeneStarType) {
                            this.atn.genTransitions(curState, kleeneTypeToNode.get((KleeneStarType)edge), curState, grule, kleeneTypeToNode, contactPoints);
                            AtnState nextState2 = this.atn.newAtnState(grule);
                            curState.addTransition(Constants.epsilon, nextState2);
                            curState = nextState2;
                            contactPoints.put((KleeneStarType)edge, curState);
                            continue;
                        }
                        if (edge instanceof KleeneCrossType) {
                            contents = kleeneTypeToNode.get((KleeneCrossType)edge);
                            nextState = this.atn.newAtnState(grule);
                            this.atn.genTransitions(curState, contents, nextState, grule, kleeneTypeToNode, contactPoints);
                            curState = nextState;
                            this.atn.genTransitions(curState, contents, curState, grule, kleeneTypeToNode, contactPoints);
                            nextState = this.atn.newAtnState(grule);
                            curState.addTransition(Constants.epsilon, nextState);
                            curState = nextState;
                            contactPoints.put((KleeneCrossType)edge, curState);
                            continue;
                        }
                        if (edge instanceof OptionalType) {
                            contents = kleeneTypeToNode.get((OptionalType)edge);
                            nextState = this.atn.newAtnState(grule);
                            this.atn.genTransitions(curState, contents, nextState, grule, kleeneTypeToNode, contactPoints);
                            curState.addTransition(Constants.epsilon, nextState);
                            curState = nextState;
                            contactPoints.put((OptionalType)edge, curState);
                            continue;
                        }
                        throw new DropinccException("Illegal transition edge of ATN: " + edge);
                    }
                    curState.addTransition(Constants.epsilon, pa1);
                    continue;
                }
                pai.addTransition(Constants.epsilon, pa1);
            }
        }
        this.atn.setContactPointMapping(this.resolveContactPointMapping(contactPoints, kleeneGenedGruleMapping));
        for (Map.Entry entry : ruleTypeToAlts.entrySet()) {
            if (((List)entry.getValue()).size() <= 1) continue;
            grule = (GruleType)entry.getKey();
            dfa = null;
            try {
                dfa = this.createAfa(this.atn.getStartState(grule), grule);
            }
            catch (NonLlRegularException ex) {
                this.nonLLRegularGrules.add(grule);
                continue;
            }
            if (dfa == null) {
                throw new DropinccException("No look-ahead DFA found for a LL-regular rule: " + grule);
            }
            this.gruleDfaMapping.put(grule, dfa);
        }
        for (Map.Entry<Object, Object> entry : this.gruleDfaMapping.entrySet()) {
            grule = (GruleType)entry.getKey();
            dfa = (LookAheadDfa)entry.getValue();
            HashSet<DfaState> dests = new HashSet<DfaState>();
            for (DfaState state : dfa.getStates()) {
                dests.addAll(state.getTransitions().values());
            }
            HashSet<DfaState> startAndDangling = new HashSet<DfaState>(dfa.getStates());
            startAndDangling.removeAll(dests);
            if (startAndDangling.isEmpty()) {
                throw new DropinccException("No start state found for look ahead dfa of grule: " + grule + ", error!");
            }
            HashSet<DfaState> dangling = new HashSet<DfaState>();
            for (DfaState state : startAndDangling) {
                if (state.getTransitions().isEmpty()) {
                    dangling.add(state);
                    continue;
                }
                dfa.setStart(state);
            }
            dfa.removeStates(dangling);
            HashSet<Integer> allAlts = new HashSet<Integer>();
            for (int i = 0; i < ((List)ruleTypeToAlts.get(grule)).size(); ++i) {
                allAlts.add(i);
            }
            HashSet<Integer> finaledAlts = new HashSet<Integer>();
            for (DfaState state : dfa.getStates()) {
                if (!state.isFinal()) continue;
                finaledAlts.add(state.getAlt());
            }
            allAlts.removeAll(finaledAlts);
            if (!allAlts.isEmpty()) {
                this.warnings.append("WARNING: Alternative productions: ").append(allAlts).append(" would never be matched, ").append("grule: ").append(grule).append('\n');
            }
            if (dfa.getStart() != null) continue;
            throw new DropinccException("No start state found for look ahead dfa of grule: " + grule + ", error!");
        }
        for (Map.Entry<Object, Object> entry : kleeneGenedGruleMapping.entrySet()) {
            KleeneType ktype = (KleeneType)entry.getKey();
            GenedKleeneGruleType gtype = (GenedKleeneGruleType)entry.getValue();
            if (this.nonLLRegularGrules.contains(gtype)) {
                this.nonLLRegularKleenes.add(ktype);
                continue;
            }
            if (!this.gruleDfaMapping.containsKey(gtype)) {
                throw new DropinccException("No look-ahead DFA found for a LL-regular rule: " + gtype);
            }
            this.kleenDfaMapping.put(ktype, this.gruleDfaMapping.get(gtype));
        }
    }

    private Map<GenedKleeneGruleType, AtnState> resolveContactPointMapping(Map<KleeneType, AtnState> contactPoints, Map<KleeneType, GenedKleeneGruleType> kleeneGenedGruleMapping) {
        HashMap<GenedKleeneGruleType, AtnState> ret = new HashMap<GenedKleeneGruleType, AtnState>();
        for (Map.Entry<KleeneType, GenedKleeneGruleType> e : kleeneGenedGruleMapping.entrySet()) {
            ret.put(e.getValue(), contactPoints.get(e.getKey()));
        }
        return ret;
    }

    public static boolean resolveWithPreds(DfaState state, Set<Integer> conflicts) {
        HashMap<Integer, Set<AtnConfig>> altToConfs = new HashMap<Integer, Set<AtnConfig>>();
        for (int i : conflicts) {
            Set<AtnConfig> confsWithPreds = state.getConfsWithPredsOfAlt(i);
            if (confsWithPreds == null || confsWithPreds.isEmpty()) continue;
            altToConfs.put(i, confsWithPreds);
        }
        if (altToConfs.size() < conflicts.size()) {
            return false;
        }
        for (Set cs : altToConfs.values()) {
            for (AtnConfig c : cs) {
                c.setResolved(true);
            }
        }
        return true;
    }

    public void resolveOverflow(DfaState state, GruleType grule) {
        if (!state.isOverflowed()) {
            return;
        }
        String stateStr = state.toString();
        state.setStopTransit(true);
        Set<Integer> conflicts = state.getAllPredictingAlts();
        if (LlstarAnalysis.resolveWithPreds(state, conflicts)) {
            return;
        }
        int minAlt = Util.minInt(conflicts);
        Iterator<AtnConfig> iter = state.getConfs().iterator();
        while (iter.hasNext()) {
            AtnConfig c = iter.next();
            if (c.getAlt() == minAlt) continue;
            iter.remove();
        }
        this.debugMsg.append("State: ").append(stateStr).append(" overflowed, resolved by removing all competing alternatives except the one defined first, remaining alt: ").append(minAlt).append(". Grule: ").append(grule).append('\n');
    }

    public void resolveConflicts(DfaState state, GruleType grule) {
        HashMap ssToAlt = new HashMap();
        for (AtnConfig conf : state.getConfs()) {
            Pair<AtnState, CallStack> k = new Pair<AtnState, CallStack>(conf.getState(), conf.getStack());
            if (!ssToAlt.containsKey(k)) {
                ssToAlt.put(k, new HashSet());
            }
            ((Set)ssToAlt.get(k)).add(conf.getAlt());
        }
        HashMap<Pair, Set> conflictsKvs = new HashMap<Pair, Set>();
        for (Map.Entry entry : ssToAlt.entrySet()) {
            Pair k = (Pair)entry.getKey();
            Set v = (Set)entry.getValue();
            if (v.size() <= 1) continue;
            conflictsKvs.put(k, v);
        }
        if (conflictsKvs.size() == 0) {
            return;
        }
        Set<Integer> allPredictingAlts = state.getAllPredictingAlts();
        for (Set confAlts : conflictsKvs.values()) {
            if (confAlts.equals(allPredictingAlts)) continue;
            return;
        }
        state.setStopTransit(true);
        if (LlstarAnalysis.resolveWithPreds(state, allPredictingAlts)) {
            return;
        }
        String stateStr = state.toString();
        int minAlt = Util.minInt(allPredictingAlts);
        Iterator<AtnConfig> iter = state.getConfs().iterator();
        while (iter.hasNext()) {
            AtnConfig c = iter.next();
            if (c.getAlt() == minAlt) continue;
            iter.remove();
        }
        this.debugMsg.append("State: ").append(stateStr).append(" has conflict predicting alternatives: ").append(allPredictingAlts).append(", resolved by selecting the first alt: ").append(minAlt).append(". Grule: ").append(grule).append('\n');
    }

    public Set<AtnConfig> closure(DfaState state, AtnConfig conf, GruleType grule) throws NonLlRegularException {
        if (state.inBusy(conf)) {
            return Collections.emptySet();
        }
        state.addToBusy(conf);
        HashSet<AtnConfig> ret = new HashSet<AtnConfig>();
        ret.add(conf);
        AtnState p = conf.getState();
        int i = conf.getAlt();
        CallStack y = conf.getStack();
        Predicate<?> pi = conf.getPred();
        if (p.isFinal()) {
            if (y.isEmpty()) {
                for (AtnState p2 : this.atn.getAllDestinationsOf(this.atn.getGruleTypeByAtnState(p))) {
                    ret.addAll(this.closure(state, new AtnConfig(p2, i, new CallStack(), pi), grule));
                }
            } else {
                Pair<AtnState, CallStack> ss = y.copyAndPop();
                ret.addAll(this.closure(state, new AtnConfig(ss.getLeft(), i, ss.getRight(), pi), grule));
            }
        }
        for (Pair<Object, AtnState> transPairs : p.getTransitionsAsPairs()) {
            Object edge = transPairs.getLeft();
            AtnState s = transPairs.getRight();
            if (edge instanceof GruleType) {
                int depth = y.computeRecurseDepth(s);
                if (depth == 1) {
                    state.addRecursiveAlt(i);
                    if (state.getRecursiveAlts().size() > 1) {
                        this.warnings.append("Likely non-LL regular grammar, recursive alts: " + state.getRecursiveAlts() + ", rule: " + grule).append('\n');
                        throw new NonLlRegularException();
                    }
                }
                if (depth >= 10) {
                    state.setOverflowed(true);
                    return ret;
                }
                CallStack stk = y.clone();
                stk.push(s);
                ret.addAll(this.closure(state, new AtnConfig(this.atn.getStartState((GruleType)edge), i, stk, pi), grule));
                continue;
            }
            if (!(edge instanceof Predicate) && !edge.equals(Constants.epsilon)) continue;
            ret.addAll(this.closure(state, new AtnConfig(s, i, y.clone(), pi), grule));
        }
        return ret;
    }

    public LookAheadDfa createAfa(AtnState atnStartState, GruleType gruleType) throws NonLlRegularException {
        LookAheadDfa ret = new LookAheadDfa();
        ArrayDeque<DfaState> work = new ArrayDeque<DfaState>();
        DfaState D0 = new DfaState();
        for (int alt = 0; alt < atnStartState.getTransitionCount(); ++alt) {
            ret.addDummyFinalState(alt);
        }
        List<Pair<Object, AtnState>> transitions = atnStartState.getTransitionsAsPairs();
        for (int i = 0; i < transitions.size(); ++i) {
            AtnState pa_i = transitions.get(i).getRight();
            Predicate pi = null;
            Object first_t = pa_i.getTransitions().entrySet().iterator().next().getKey();
            if (first_t instanceof Predicate) {
                pi = (Predicate)first_t;
            }
            D0.addAllConfs(this.closure(D0, new AtnConfig(pa_i, LlstarAnalysis.extractAltFromAltState(pa_i), new CallStack(), pi), gruleType));
            D0.releaseBusy();
        }
        work.push(D0);
        ret.addState(D0);
        while (!work.isEmpty()) {
            DfaState state = (DfaState)work.pop();
            HashSet<TokenType> newTrans = new HashSet<TokenType>();
            int newWorkCount = 0;
            HashSet<DfaState> newStates = new HashSet<DfaState>();
            HashMap<Integer, DfaState> finalsBack = new HashMap<Integer, DfaState>();
            block3: for (TokenType tokenType : state.getAllTerminalEdgesOfContainingAtnStates()) {
                DfaState dfaState = new DfaState();
                for (AtnConfig conf : state.move(tokenType)) {
                    dfaState.addAllConfs(this.closure(state, conf, gruleType));
                    state.releaseBusy();
                    this.resolveOverflow(state, gruleType);
                    this.checkIfFinalAndReplace(state, ret, finalsBack, false);
                    if (!state.isStopTransit()) continue;
                    break block3;
                }
                if (!ret.containState(dfaState)) {
                    this.resolveConflicts(dfaState, gruleType);
                    if (!this.checkIfFinalAndReplace(dfaState, ret, finalsBack, true)) {
                        work.push(dfaState);
                        ++newWorkCount;
                    }
                    ret.addState(dfaState);
                    newStates.add(dfaState);
                    state.addTransition(tokenType, dfaState);
                    newTrans.add(tokenType);
                    continue;
                }
                state.addTransition(tokenType, ret.getSameState(dfaState));
                newTrans.add(tokenType);
            }
            if (state.isStopTransit()) {
                ret.removeStates(newStates);
                state.removeTransitions(newTrans);
                for (Map.Entry entry : finalsBack.entrySet()) {
                    DfaState dfaState = (DfaState)entry.getValue();
                    ret.addState(dfaState);
                    ret.overrideFinalState((Integer)entry.getKey(), dfaState);
                }
                for (int i = 0; i < newWorkCount; ++i) {
                    work.pop();
                }
            }
            HashSet predTrans = new HashSet();
            for (AtnConfig atnConfig : state.getResolvedConfs()) {
                predTrans.add(new Pair(atnConfig.getPred(), ret.getFinalStateOfAlt(atnConfig.getAlt())));
            }
            for (Pair pair : predTrans) {
                state.addTransition(pair.getLeft(), (DfaState)pair.getRight());
            }
        }
        return ret;
    }

    private boolean checkIfFinalAndReplace(DfaState state, LookAheadDfa dnet, Map<Integer, DfaState> finalsBack, boolean backup) {
        Set<Integer> predictingAlts = state.getAllPredictingAlts();
        if (predictingAlts.size() == 1) {
            int alt = predictingAlts.iterator().next();
            state.setAlt(alt);
            DfaState oldFinal = dnet.overrideFinalState(alt, state);
            if (backup && !finalsBack.containsKey(alt)) {
                finalsBack.put(alt, oldFinal);
            }
            state.setStopTransit(true);
            return true;
        }
        return false;
    }

    private static int extractAltFromAltState(AtnState pai) {
        String name = pai.getName();
        return Integer.parseInt(name.substring(name.indexOf(95) + 1));
    }

    public String getWarnings() {
        return this.warnings.toString();
    }

    public String getDebugMsg() {
        return this.debugMsg.toString();
    }

    public Atn getAtn() {
        return this.atn;
    }

    public LookAheadDfa getLookAheadDfa(GruleType grule) {
        return this.gruleDfaMapping.get(grule);
    }

    public Map<KleeneType, LookAheadDfa> getKleenDfaMapping() {
        return this.kleenDfaMapping;
    }

    public Set<GruleType> getNonLLRegularGrules() {
        return this.nonLLRegularGrules;
    }

    public Set<KleeneType> getNonLLRegularKleenes() {
        return this.nonLLRegularKleenes;
    }
}

