/*
 * Decompiled with CFR 0.152.
 */
package com.github.pfmiles.dropincc.impl.llstar;

import com.github.pfmiles.dropincc.DropinccException;
import com.github.pfmiles.dropincc.Predicate;
import com.github.pfmiles.dropincc.impl.TokenType;
import com.github.pfmiles.dropincc.impl.llstar.AtnConfig;
import com.github.pfmiles.dropincc.impl.llstar.AtnState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DfaState {
    private Set<AtnConfig> confs = new HashSet<AtnConfig>();
    private Map<Object, DfaState> transitions = new HashMap<Object, DfaState>();
    private Set<AtnConfig> busy = new HashSet<AtnConfig>();
    private Set<Integer> recursiveAlts = new HashSet<Integer>();
    private int alt = -1;
    private boolean overflowed;
    private boolean stopTransit;
    private String name;

    public List<AtnConfig> getResolvedConfs() {
        ArrayList<AtnConfig> ret = new ArrayList<AtnConfig>();
        for (AtnConfig c : this.confs) {
            if (!c.isResolved()) continue;
            ret.add(c);
        }
        return ret;
    }

    public void removeTransitions(Set<TokenType> trans) {
        this.transitions.keySet().removeAll(trans);
    }

    public void addToBusy(AtnConfig conf) {
        this.busy.add(conf);
    }

    public boolean inBusy(AtnConfig conf) {
        return this.busy.contains(conf);
    }

    public void addRecursiveAlt(int recAlt) {
        this.recursiveAlts.add(recAlt);
    }

    public void releaseBusy() {
        this.busy.clear();
    }

    public Set<AtnConfig> move(TokenType t) {
        HashSet<AtnConfig> ret = new HashSet<AtnConfig>();
        for (AtnConfig c : this.confs) {
            Set<AtnState> dests = c.getState().transit(t);
            if (dests.size() == 0) continue;
            for (AtnState d : dests) {
                ret.add(new AtnConfig(d, c.getAlt(), c.getStack().clone(), c.getPred()));
            }
        }
        return ret;
    }

    public Set<TokenType> getAllTerminalEdgesOfContainingAtnStates() {
        HashSet<TokenType> ret = new HashSet<TokenType>();
        for (AtnConfig c : this.confs) {
            for (Object edge : c.getState().getTransitions().keySet()) {
                if (!(edge instanceof TokenType)) continue;
                ret.add((TokenType)edge);
            }
        }
        return ret;
    }

    public Set<Integer> getAllPredictingAlts() {
        HashSet<Integer> ret = new HashSet<Integer>();
        if (this.isFinal()) {
            ret.add(this.alt);
        } else {
            for (AtnConfig c : this.confs) {
                ret.add(c.getAlt());
            }
        }
        return ret;
    }

    public boolean isFinal() {
        return this.alt > -1;
    }

    public void addAllConfs(Collection<AtnConfig> confs) {
        this.confs.addAll(confs);
    }

    public void removeConf(AtnConfig conf) {
        this.confs.remove(conf);
    }

    public Set<AtnConfig> getConfsWithPredsOfAlt(int alt) {
        HashSet<AtnConfig> ret = new HashSet<AtnConfig>();
        for (AtnConfig c : this.confs) {
            if (c.getPred() == null || c.getAlt() != alt) continue;
            ret.add(c);
        }
        return ret;
    }

    public String toString() {
        return this.confs.toString();
    }

    public void addConf(AtnConfig conf) {
        this.confs.add(conf);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.confs == null ? 0 : this.confs.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DfaState other = (DfaState)obj;
        return !(this.confs == null ? other.confs != null : !this.confs.equals(other.confs));
    }

    public void addTransition(Object edge, DfaState target) {
        if (!(edge instanceof TokenType) && !(edge instanceof Predicate)) {
            throw new DropinccException("Illegal transition edge for DfaState, only TokenType or Predicates are permitted, edge: " + edge);
        }
        this.transitions.put(edge, target);
    }

    public boolean isOverflowed() {
        return this.overflowed;
    }

    public void setOverflowed(boolean overflowed) {
        this.overflowed = overflowed;
    }

    public boolean isStopTransit() {
        return this.stopTransit;
    }

    public void setStopTransit(boolean stopTransit) {
        this.stopTransit = stopTransit;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<Object, DfaState> getTransitions() {
        return this.transitions;
    }

    public Set<AtnConfig> getConfs() {
        return this.confs;
    }

    public Set<Integer> getRecursiveAlts() {
        return this.recursiveAlts;
    }

    public int getAlt() {
        return this.alt;
    }

    public void setAlt(int alt) {
        this.alt = alt;
    }
}

