/*
 * Decompiled with CFR 0.152.
 */
package com.github.pfmiles.dropincc.impl.llstar;

import com.github.pfmiles.dropincc.DropinccException;
import com.github.pfmiles.dropincc.impl.llstar.AtnState;
import com.github.pfmiles.dropincc.impl.util.Pair;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;

public class CallStack
implements Cloneable {
    private Deque<AtnState> stack = new ArrayDeque<AtnState>();

    public CallStack clone() {
        CallStack cp = null;
        try {
            cp = (CallStack)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new DropinccException(e);
        }
        cp.stack = new ArrayDeque<AtnState>(this.stack);
        return cp;
    }

    public int computeRecurseDepth(AtnState s) {
        int ret = 0;
        for (AtnState ss : this.stack) {
            if (!ss.equals(s)) continue;
            ++ret;
        }
        return ret;
    }

    public Pair<AtnState, CallStack> copyAndPop() {
        CallStack cp = this.clone();
        AtnState s = cp.pop();
        return new Pair<AtnState, CallStack>(s, cp);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (AtnState s : this.stack) {
            if (sb.length() != 1) {
                sb.append(", ");
            }
            sb.append(s.getName());
        }
        sb.append("]");
        return sb.toString();
    }

    public void push(AtnState s) {
        this.stack.push(s);
    }

    public AtnState pop() {
        return this.stack.pop();
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CallStack other = (CallStack)obj;
        if (this.stack == null) {
            return other.stack == null;
        }
        if (other.stack == null) {
            return false;
        }
        if (this.stack.isEmpty() || other.stack.isEmpty()) {
            return true;
        }
        Iterator<AtnState> iter1 = this.stack.iterator();
        Iterator<AtnState> iter2 = other.stack.iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            if (iter1.next().equals(iter2.next())) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }
}

