/*
 * Decompiled with CFR 0.152.
 */
package com.github.pfmiles.dropincc.impl.llstar;

import com.github.pfmiles.dropincc.DropinccException;
import com.github.pfmiles.dropincc.Predicate;
import com.github.pfmiles.dropincc.impl.GruleType;
import com.github.pfmiles.dropincc.impl.TokenType;
import com.github.pfmiles.dropincc.impl.llstar.Constants;
import com.github.pfmiles.dropincc.impl.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AtnState {
    private String name;
    private Map<Object, Set<AtnState>> transitions = new HashMap<Object, Set<AtnState>>();
    private boolean _final;

    public List<Pair<Object, AtnState>> getTransitionsAsPairs() {
        ArrayList<Pair<Object, AtnState>> ret = new ArrayList<Pair<Object, AtnState>>();
        for (Map.Entry<Object, Set<AtnState>> e : this.transitions.entrySet()) {
            Object edge = e.getKey();
            for (AtnState s : e.getValue()) {
                ret.add(new Pair<Object, AtnState>(edge, s));
            }
        }
        return ret;
    }

    public AtnState(String name, boolean _final) {
        this.name = "p" + name;
        this._final = _final;
    }

    public AtnState(String name) {
        this(name, false);
    }

    public void addTransition(Object edge, AtnState otherState) {
        if (!(edge.equals(Constants.epsilon) || edge instanceof TokenType || edge instanceof GruleType || edge instanceof Predicate)) {
            throw new DropinccException("Illegal ATN transition edge: " + edge);
        }
        if (this.transitions.containsKey(edge)) {
            this.transitions.get(edge).add(otherState);
        } else {
            HashSet<AtnState> set = new HashSet<AtnState>();
            set.add(otherState);
            this.transitions.put(edge, set);
        }
    }

    public Set<AtnState> transit(Object edge) {
        if (this.transitions.containsKey(edge)) {
            return this.transitions.get(edge);
        }
        return Collections.emptySet();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AtnState other = (AtnState)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return "AtnState(" + this.name + ")";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<Object, Set<AtnState>> getTransitions() {
        return this.transitions;
    }

    public boolean isFinal() {
        return this._final;
    }

    public void setFinal(boolean f) {
        this._final = f;
    }

    public int getTransitionCount() {
        int ret = 0;
        for (Set<AtnState> dests : this.transitions.values()) {
            ret += dests.size();
        }
        return ret;
    }
}

