/*
 * Decompiled with CFR 0.152.
 */
package com.github.pfmiles.dropincc.impl.llstar;

import com.github.pfmiles.dropincc.DropinccException;
import com.github.pfmiles.dropincc.impl.EleType;
import com.github.pfmiles.dropincc.impl.GruleType;
import com.github.pfmiles.dropincc.impl.TokenType;
import com.github.pfmiles.dropincc.impl.kleene.KleeneCrossType;
import com.github.pfmiles.dropincc.impl.kleene.KleeneStarType;
import com.github.pfmiles.dropincc.impl.kleene.KleeneType;
import com.github.pfmiles.dropincc.impl.kleene.OptionalType;
import com.github.pfmiles.dropincc.impl.llstar.AtnState;
import com.github.pfmiles.dropincc.impl.llstar.Constants;
import com.github.pfmiles.dropincc.impl.llstar.GenedKleeneGruleType;
import com.github.pfmiles.dropincc.impl.util.SeqGen;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Atn {
    private Set<AtnState> states = new HashSet<AtnState>();
    private Map<GruleType, AtnState> gruleTypeStartStateMapping = new HashMap<GruleType, AtnState>();
    private Map<AtnState, GruleType> stateGruleTypeMapping = new HashMap<AtnState, GruleType>();
    private SeqGen normalStateSeq = new SeqGen();
    private Map<GenedKleeneGruleType, AtnState> contactPointMapping;

    public Set<AtnState> getAllDestinationsOf(Object edge) {
        if (edge instanceof GenedKleeneGruleType) {
            if (!this.contactPointMapping.containsKey((GenedKleeneGruleType)edge)) {
                throw new DropinccException("Couldn't find ATN contact point for generated kleene grule, ERROR! KleenType: " + edge);
            }
            HashSet<AtnState> ret = new HashSet<AtnState>();
            ret.add(this.contactPointMapping.get((GenedKleeneGruleType)edge));
            return ret;
        }
        HashSet<AtnState> ret = new HashSet<AtnState>();
        for (AtnState state : this.states) {
            if (!state.getTransitions().containsKey(edge)) continue;
            ret.addAll((Collection<AtnState>)state.getTransitions().get(edge));
        }
        return ret;
    }

    public AtnState getStartState(GruleType gruleType) {
        return this.gruleTypeStartStateMapping.get(gruleType);
    }

    public String toDot() {
        return this.toString();
    }

    public String toString() {
        return "Atn(" + this.states + ")";
    }

    public GruleType getGruleTypeByAtnState(AtnState state) {
        return this.stateGruleTypeMapping.get(state);
    }

    public AtnState newStartStateForGrule(GruleType grule) {
        AtnState ret = new AtnState("R" + grule.getDefIndex());
        this.states.add(ret);
        this.stateGruleTypeMapping.put(ret, grule);
        this.gruleTypeStartStateMapping.put(grule, ret);
        return ret;
    }

    public AtnState newEndStateForGrule(GruleType grule) {
        AtnState ret = new AtnState("R" + grule.getDefIndex() + "_end", true);
        this.states.add(ret);
        this.stateGruleTypeMapping.put(ret, grule);
        return ret;
    }

    public AtnState newAltStateForGrule(GruleType grule, int i) {
        AtnState ret = new AtnState("R" + grule.getDefIndex() + "_" + i);
        this.states.add(ret);
        this.stateGruleTypeMapping.put(ret, grule);
        return ret;
    }

    public AtnState newAtnState(GruleType grule) {
        AtnState ret = new AtnState(String.valueOf(this.normalStateSeq.next()));
        this.states.add(ret);
        this.stateGruleTypeMapping.put(ret, grule);
        return ret;
    }

    public void genTransitions(AtnState start, List<EleType> edges, AtnState end, GruleType grule, Map<KleeneType, List<EleType>> kleeneTypeToNode, Map<KleeneType, AtnState> contactPoints) {
        AtnState curState = start;
        EleType lastEdge = edges.get(edges.size() - 1);
        for (int i = 0; i < edges.size() - 1; ++i) {
            AtnState nextState;
            AtnState nextState2;
            EleType edge = edges.get(i);
            if (edge instanceof TokenType || edge instanceof GruleType) {
                nextState2 = this.newAtnState(grule);
                curState.addTransition(edge, nextState2);
                curState = nextState2;
                continue;
            }
            if (edge instanceof KleeneStarType) {
                this.genTransitions(curState, kleeneTypeToNode.get((KleeneStarType)edge), curState, grule, kleeneTypeToNode, contactPoints);
                nextState2 = this.newAtnState(grule);
                curState.addTransition(Constants.epsilon, nextState2);
                curState = nextState2;
                contactPoints.put((KleeneStarType)edge, curState);
                continue;
            }
            if (edge instanceof KleeneCrossType) {
                List<EleType> content = kleeneTypeToNode.get((KleeneCrossType)edge);
                nextState = this.newAtnState(grule);
                this.genTransitions(curState, content, nextState, grule, kleeneTypeToNode, contactPoints);
                curState = nextState;
                this.genTransitions(curState, content, curState, grule, kleeneTypeToNode, contactPoints);
                nextState = this.newAtnState(grule);
                curState.addTransition(Constants.epsilon, nextState);
                curState = nextState;
                contactPoints.put((KleeneCrossType)edge, curState);
                continue;
            }
            if (edge instanceof OptionalType) {
                List<EleType> contents = kleeneTypeToNode.get((OptionalType)edge);
                nextState = this.newAtnState(grule);
                this.genTransitions(curState, contents, nextState, grule, kleeneTypeToNode, contactPoints);
                curState.addTransition(Constants.epsilon, nextState);
                curState = nextState;
                contactPoints.put((OptionalType)edge, curState);
                continue;
            }
            throw new DropinccException("Illegal transition edge of ATN: " + edge);
        }
        if (lastEdge instanceof TokenType || lastEdge instanceof GruleType) {
            curState.addTransition(lastEdge, end);
        } else if (lastEdge instanceof KleeneStarType) {
            this.genTransitions(curState, kleeneTypeToNode.get((KleeneStarType)lastEdge), curState, grule, kleeneTypeToNode, contactPoints);
            curState.addTransition(Constants.epsilon, end);
            contactPoints.put((KleeneStarType)lastEdge, end);
        } else if (lastEdge instanceof KleeneCrossType) {
            List<EleType> content = kleeneTypeToNode.get((KleeneCrossType)lastEdge);
            AtnState nextState = this.newAtnState(grule);
            this.genTransitions(curState, content, nextState, grule, kleeneTypeToNode, contactPoints);
            curState = nextState;
            this.genTransitions(curState, content, curState, grule, kleeneTypeToNode, contactPoints);
            curState.addTransition(Constants.epsilon, end);
            contactPoints.put((KleeneCrossType)lastEdge, end);
        } else if (lastEdge instanceof OptionalType) {
            List<EleType> contents = kleeneTypeToNode.get((OptionalType)lastEdge);
            this.genTransitions(curState, contents, end, grule, kleeneTypeToNode, contactPoints);
            curState.addTransition(Constants.epsilon, end);
            contactPoints.put((OptionalType)lastEdge, end);
        } else {
            throw new DropinccException("Illegal transition edge of ATN: " + lastEdge);
        }
    }

    public Set<AtnState> getStates() {
        return this.states;
    }

    public void setContactPointMapping(Map<GenedKleeneGruleType, AtnState> contactPointMapping) {
        this.contactPointMapping = contactPointMapping;
    }
}

