/*
 * Decompiled with CFR 0.152.
 */
package com.github.pfmiles.dropincc.impl.lexical;

import com.github.pfmiles.dropincc.CC;
import com.github.pfmiles.dropincc.DropinccException;
import com.github.pfmiles.dropincc.Element;
import com.github.pfmiles.dropincc.Grule;
import com.github.pfmiles.dropincc.TokenDef;
import com.github.pfmiles.dropincc.impl.Alternative;
import com.github.pfmiles.dropincc.impl.AndSubRule;
import com.github.pfmiles.dropincc.impl.ConstructingGrule;
import com.github.pfmiles.dropincc.impl.OrSubRule;
import com.github.pfmiles.dropincc.impl.TokenType;
import com.github.pfmiles.dropincc.impl.kleene.AbstractKleeneNode;
import com.github.pfmiles.dropincc.impl.lexical.GenedTokenDef;
import com.github.pfmiles.dropincc.impl.lexical.InstantTokenDef;
import com.github.pfmiles.dropincc.impl.util.Pair;
import com.github.pfmiles.dropincc.impl.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class LexerCompiler {
    public static Map<TokenDef, TokenType> buildTokenTypeMapping(List<TokenDef> tokens, boolean whitespaceSensitive) {
        HashMap<TokenDef, TokenType> tokenTypeMapping = new HashMap<TokenDef, TokenType>();
        if (tokens != null) {
            int i = 0;
            for (TokenDef t : tokens) {
                if (tokenTypeMapping.containsKey(t)) continue;
                tokenTypeMapping.put(t, new TokenType(i, t.getRegexp()));
                ++i;
            }
            tokenTypeMapping.put(CC.EOF, TokenType.EOF);
            if (!whitespaceSensitive) {
                GenedTokenDef whiteSpaceToken = new GenedTokenDef("\\s+");
                tokens.add(whiteSpaceToken);
                tokenTypeMapping.put(whiteSpaceToken, TokenType.WHITESPACE);
            }
        }
        return tokenTypeMapping;
    }

    public static Pair<Map<Integer, TokenType>, Pattern> checkAndCompileTokenRules(List<TokenDef> tokens, Map<TokenDef, TokenType> tokenTypeMapping) {
        LexerCompiler.checkRegexps(tokens);
        return LexerCompiler.combineAndCompileRules(tokens, tokenTypeMapping);
    }

    private static void checkRegexps(List<TokenDef> tokens) {
        for (TokenDef t : tokens) {
            if (Util.isEmpty(t.getRegexp())) {
                throw new DropinccException("Cannot create null token.");
            }
            try {
                Pattern.compile(t.getRegexp());
            }
            catch (PatternSyntaxException e) {
                throw new DropinccException("Invalid token rule: '" + t.getRegexp() + "'", e);
            }
        }
    }

    private static Pair<Map<Integer, TokenType>, Pattern> combineAndCompileRules(List<TokenDef> tokens, Map<TokenDef, TokenType> tokenTypeMapping) {
        HashMap<Integer, TokenType> groupNumToType = new HashMap<Integer, TokenType>();
        StringBuilder sb = new StringBuilder();
        int groupCount = 1;
        for (TokenDef t : tokens) {
            if (t.equals(CC.EOF)) continue;
            if (sb.length() != 0) {
                sb.append("|");
            }
            sb.append("(\\G");
            String regExp = t.getRegexp();
            sb.append(regExp);
            groupNumToType.put(groupCount, tokenTypeMapping.get(t));
            sb.append(")");
            ++groupCount;
            groupCount += LexerCompiler.countInnerGroups(regExp);
        }
        return new Pair<Map<Integer, TokenType>, Pattern>(groupNumToType, Pattern.compile(sb.toString()));
    }

    private static int countInnerGroups(String regExp) {
        int ret = 0;
        for (int i = 0; i < regExp.length(); ++i) {
            if ('(' != regExp.charAt(i) || i - 1 >= 0 && '\\' == regExp.charAt(i - 1)) continue;
            ++ret;
        }
        return ret;
    }

    public static List<InstantTokenDef> collectInstantTokenDefs(List<Grule> grules) {
        ArrayList<InstantTokenDef> ret = new ArrayList<InstantTokenDef>();
        HashSet<Element> traversed = new HashSet<Element>();
        for (Grule g : grules) {
            traversed.add(g);
            ret.addAll(LexerCompiler.collectInstantTokenDefFromAlts(g.getAlts(), traversed));
        }
        return ret;
    }

    private static List<InstantTokenDef> collectInstantTokenDefFromAlts(List<Alternative> alts, Set<Element> traversed) {
        ArrayList<InstantTokenDef> ret = new ArrayList<InstantTokenDef>();
        for (Alternative alt : alts) {
            ret.addAll(LexerCompiler.collectInstantTokenDefFromElements(alt.getElements(), traversed));
        }
        return ret;
    }

    private static List<InstantTokenDef> collectInstantTokenDefFromElements(List<Element> eles, Set<Element> traversed) {
        ArrayList<InstantTokenDef> ret = new ArrayList<InstantTokenDef>();
        for (Element ele : eles) {
            if (traversed.contains(ele)) continue;
            traversed.add(ele);
            if (ele instanceof AbstractKleeneNode) {
                ret.addAll(LexerCompiler.collectInstantTokenDefFromElements(((AbstractKleeneNode)ele).getElements(), traversed));
                continue;
            }
            if (ele instanceof AndSubRule) {
                ret.addAll(LexerCompiler.collectInstantTokenDefFromAlts(((AndSubRule)ele).getAlts(), traversed));
                continue;
            }
            if (ele instanceof OrSubRule) {
                ret.addAll(LexerCompiler.collectInstantTokenDefFromAlts(((OrSubRule)ele).getAlts(), traversed));
                continue;
            }
            if (ele instanceof ConstructingGrule) {
                throw new DropinccException("Something must be wrong, ConstructingGrule shouldn't appear here");
            }
            if (ele instanceof Grule) {
                ret.addAll(LexerCompiler.collectInstantTokenDefFromAlts(((Grule)ele).getAlts(), traversed));
                continue;
            }
            if (!(ele instanceof InstantTokenDef)) continue;
            ret.add((InstantTokenDef)ele);
        }
        return ret;
    }
}

