/*
 * Decompiled with CFR 0.152.
 */
package com.github.pfmiles.dropincc.impl.kleene;

import com.github.pfmiles.dropincc.CC;
import com.github.pfmiles.dropincc.DropinccException;
import com.github.pfmiles.dropincc.Element;
import com.github.pfmiles.dropincc.Grule;
import com.github.pfmiles.dropincc.TokenDef;
import com.github.pfmiles.dropincc.impl.Alternative;
import com.github.pfmiles.dropincc.impl.EleType;
import com.github.pfmiles.dropincc.impl.GruleType;
import com.github.pfmiles.dropincc.impl.TypeMappingParam;
import com.github.pfmiles.dropincc.impl.kleene.AbstractKleeneNode;
import com.github.pfmiles.dropincc.impl.kleene.KleeneCrossNode;
import com.github.pfmiles.dropincc.impl.kleene.KleeneCrossType;
import com.github.pfmiles.dropincc.impl.kleene.KleeneStarNode;
import com.github.pfmiles.dropincc.impl.kleene.KleeneStarType;
import com.github.pfmiles.dropincc.impl.kleene.KleeneType;
import com.github.pfmiles.dropincc.impl.kleene.OptionalNode;
import com.github.pfmiles.dropincc.impl.kleene.OptionalType;
import com.github.pfmiles.dropincc.impl.util.Counter;
import com.github.pfmiles.dropincc.impl.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class KleeneCompiler {
    public static Map<AbstractKleeneNode, KleeneType> buildKleeneTypeMapping(Map<Grule, GruleType> gruleTypeMapping) {
        HashMap<AbstractKleeneNode, KleeneType> ret = new HashMap<AbstractKleeneNode, KleeneType>();
        HashSet<Grule> examinedGrules = new HashSet<Grule>();
        Counter kleeneCount = new Counter(0);
        for (Map.Entry<Grule, GruleType> entry : gruleTypeMapping.entrySet()) {
            KleeneCompiler.registerKleenesInGrule(entry.getKey(), kleeneCount, ret, examinedGrules);
        }
        return ret;
    }

    private static void registerKleenesInGrule(Grule grule, Counter kleeneCount, Map<AbstractKleeneNode, KleeneType> ret, Set<Grule> examinedGrules) {
        if (examinedGrules.contains(grule)) {
            return;
        }
        examinedGrules.add(grule);
        for (Alternative alt : grule.getAlts()) {
            KleeneCompiler.registerKleenesInElements(alt.getElements(), kleeneCount, ret, examinedGrules);
        }
    }

    private static void registerKleenesInElements(List<Element> elements, Counter kleeneCount, Map<AbstractKleeneNode, KleeneType> kleeneTypeMapping, Set<Grule> examinedGrules) {
        for (Element e : elements) {
            Class<?> eleCls = e.getClass();
            if (Grule.class.isAssignableFrom(eleCls)) {
                KleeneCompiler.registerKleenesInGrule((Grule)e, kleeneCount, kleeneTypeMapping, examinedGrules);
                continue;
            }
            if (AbstractKleeneNode.class.isAssignableFrom(eleCls)) {
                if (kleeneTypeMapping.containsKey(e)) continue;
                kleeneTypeMapping.put((AbstractKleeneNode)e, KleeneCompiler.constructKleeneType((AbstractKleeneNode)e, kleeneCount));
                KleeneCompiler.registerKleenesInElements(((AbstractKleeneNode)e).getElements(), kleeneCount, kleeneTypeMapping, examinedGrules);
                continue;
            }
            if (TokenDef.class.isAssignableFrom(eleCls) || CC.NOTHING.equals(e)) continue;
            throw new DropinccException("Unexpected element encountered when register kleene node: " + e);
        }
    }

    private static KleeneType constructKleeneType(AbstractKleeneNode e, Counter kleeneCount) {
        Class<?> eleCls = e.getClass();
        KleeneType ret = null;
        if (KleeneCrossNode.class.isAssignableFrom(eleCls)) {
            ret = new KleeneCrossType(kleeneCount.getCount());
        } else if (KleeneStarNode.class.isAssignableFrom(eleCls)) {
            ret = new KleeneStarType(kleeneCount.getCount());
        } else if (OptionalNode.class.isAssignableFrom(eleCls)) {
            ret = new OptionalType(kleeneCount.getCount());
        } else {
            throw new DropinccException("Unhandled kleene node: " + e);
        }
        kleeneCount.countByOne();
        return ret;
    }

    public static Map<KleeneType, List<EleType>> buildKleeneTypeToNode(TypeMappingParam param) {
        HashMap<KleeneType, List<EleType>> kleeneTypeToNode = new HashMap<KleeneType, List<EleType>>();
        for (Map.Entry<AbstractKleeneNode, KleeneType> entry : param.getKleeneTypeMapping().entrySet()) {
            kleeneTypeToNode.put(entry.getValue(), KleeneCompiler.resolveCKleeneNode(entry.getKey(), param));
        }
        return kleeneTypeToNode;
    }

    private static List<EleType> resolveCKleeneNode(AbstractKleeneNode node, TypeMappingParam param) {
        ArrayList<EleType> content = new ArrayList<EleType>();
        if (node == null || node.getElements() == null || node.getElements().isEmpty()) {
            throw new DropinccException("Cannot create empty kleene node: " + node);
        }
        for (Element e : node.getElements()) {
            EleType t = Util.resolveEleType(e, param);
            if (t == null) {
                throw new DropinccException("Could not resolve element type for element: " + e + ", is this element defined in a proper manner?");
            }
            content.add(t);
        }
        return content;
    }
}

