/*
 * Decompiled with CFR 0.152.
 */
package com.github.pfmiles.dropincc.impl.kleene;

import com.github.pfmiles.dropincc.DropinccException;
import com.github.pfmiles.dropincc.Element;
import com.github.pfmiles.dropincc.impl.AndSubRule;
import com.github.pfmiles.dropincc.impl.OrSubRule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractKleeneNode
implements Element {
    protected List<Element> elements = new ArrayList<Element>();

    protected AbstractKleeneNode(Element ... elements) {
        if (elements == null || elements.length == 0) {
            throw new DropinccException("Could not create empty kleene closure node.");
        }
        if (!this.allNotNull(elements)) {
            throw new DropinccException("Null element contained in kleene node, illegal!");
        }
        Collections.addAll(this.elements, elements);
    }

    private boolean allNotNull(Element[] eles) {
        for (Element ele : eles) {
            if (ele != null) continue;
            return false;
        }
        return true;
    }

    public AndSubRule and(Object obj) {
        return new AndSubRule(this, obj);
    }

    public OrSubRule or(Object ... objs) {
        return new OrSubRule(this, objs);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public abstract String toString();

    public List<Element> getElements() {
        return this.elements;
    }
}

