/*
 * Decompiled with CFR 0.152.
 */
package com.github.pfmiles.dropincc.impl.hotcompile;

import com.github.pfmiles.dropincc.impl.hotcompile.JavaMemCls;
import com.github.pfmiles.dropincc.impl.hotcompile.JavaStringSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;

public class MemClsFileManager
extends ForwardingJavaFileManager<StandardJavaFileManager> {
    private Map<String, JavaMemCls> destFiles;
    private Map<String, JavaStringSource> srcFiles;

    protected MemClsFileManager(StandardJavaFileManager fileManager, Map<String, JavaMemCls> destFiles, Map<String, JavaStringSource> srcFiles) {
        super(fileManager);
        this.destFiles = destFiles;
        this.srcFiles = srcFiles;
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        if (!JavaFileObject.Kind.CLASS.equals((Object)kind) || !StandardLocation.CLASS_OUTPUT.equals(location)) {
            return super.getJavaFileForOutput(location, className, kind, sibling);
        }
        if (this.destFiles.containsKey(className)) {
            return this.destFiles.get(className);
        }
        JavaMemCls file = new JavaMemCls(className);
        this.destFiles.put(className, file);
        return file;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.destFiles = null;
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        Iterable<JavaFileObject> superList;
        String pkgName;
        ArrayList<JavaFileObject> ret = new ArrayList<JavaFileObject>();
        if ((StandardLocation.CLASS_OUTPUT.equals(location) || StandardLocation.CLASS_PATH.equals(location)) && kinds.contains((Object)JavaFileObject.Kind.CLASS)) {
            for (Map.Entry<String, JavaMemCls> entry : this.destFiles.entrySet()) {
                pkgName = this.resolvePkgName(entry.getKey());
                if (recurse) {
                    if (!pkgName.contains(packageName)) continue;
                    ret.add(entry.getValue());
                    continue;
                }
                if (!pkgName.equals(packageName)) continue;
                ret.add(entry.getValue());
            }
        } else if (StandardLocation.SOURCE_PATH.equals(location) && kinds.contains((Object)JavaFileObject.Kind.SOURCE)) {
            for (Map.Entry<String, SimpleJavaFileObject> entry : this.srcFiles.entrySet()) {
                pkgName = this.resolvePkgName(entry.getKey());
                if (recurse) {
                    if (!pkgName.contains(packageName)) continue;
                    ret.add(entry.getValue());
                    continue;
                }
                if (!pkgName.equals(packageName)) continue;
                ret.add(entry.getValue());
            }
        }
        if ((superList = super.list(location, packageName, kinds, recurse)) != null) {
            for (JavaFileObject f : superList) {
                ret.add(f);
            }
        }
        return ret;
    }

    private String resolvePkgName(String fullQualifiedClsName) {
        return fullQualifiedClsName.substring(0, fullQualifiedClsName.lastIndexOf(46));
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (file instanceof JavaMemCls) {
            return ((JavaMemCls)file).getClsName();
        }
        if (file instanceof JavaStringSource) {
            return ((JavaStringSource)file).getClsName();
        }
        return super.inferBinaryName(location, file);
    }
}

