/*
 * Decompiled with CFR 0.152.
 */
package com.github.pfmiles.dropincc.impl.hotcompile;

import com.github.pfmiles.dropincc.DropinccException;
import com.github.pfmiles.dropincc.impl.hotcompile.CompilationResult;
import com.github.pfmiles.dropincc.impl.hotcompile.HotCompileClassLoader;
import com.github.pfmiles.dropincc.impl.hotcompile.HotCompileConstants;
import com.github.pfmiles.dropincc.impl.hotcompile.JavaMemCls;
import com.github.pfmiles.dropincc.impl.hotcompile.JavaStringSource;
import com.github.pfmiles.dropincc.impl.hotcompile.MemClsFileManager;
import com.github.pfmiles.dropincc.impl.util.Util;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.ToolProvider;

public class HotCompileUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompilationResult compile(String qualifiedName, String sourceCode) {
        JavaStringSource source = new JavaStringSource(qualifiedName, sourceCode);
        List<JavaStringSource> ss = Arrays.asList(source);
        List<String> options = Arrays.asList("-classpath", HotCompileConstants.CLASSPATH);
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        JavaFileManager fileManager = null;
        HashMap<String, JavaMemCls> clses = new HashMap<String, JavaMemCls>();
        HashMap<String, JavaStringSource> srcs = new HashMap<String, JavaStringSource>();
        srcs.put(source.getClsName(), source);
        try {
            fileManager = new MemClsFileManager(compiler.getStandardFileManager(null, null, null), clses, srcs);
            DiagnosticCollector diagnostics = new DiagnosticCollector();
            StringWriter out = new StringWriter();
            JavaCompiler.CompilationTask task = compiler.getTask(out, fileManager, diagnostics, options, null, ss);
            boolean sucess = task.call();
            if (!sucess) {
                for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                    out.append("Error on line " + diagnostic.getLineNumber() + " in " + diagnostic).append('\n');
                }
                CompilationResult compilationResult = new CompilationResult(out.toString());
                return compilationResult;
            }
        }
        finally {
            try {
                fileManager.close();
            }
            catch (Exception e) {
                throw new DropinccException(e);
            }
        }
        HotCompileClassLoader loader = new HotCompileClassLoader(Util.getParentClsLoader(), clses);
        Class<?> cls = null;
        try {
            cls = loader.loadClass(qualifiedName);
        }
        catch (ClassNotFoundException e) {
            throw new DropinccException(e);
        }
        return new CompilationResult(cls, loader);
    }
}

