/*
 * Decompiled with CFR 0.152.
 */
package com.github.pfmiles.dropincc.impl.automataview;

import com.github.pfmiles.dropincc.impl.automataview.GeneratingState;
import com.github.pfmiles.dropincc.impl.util.Pair;
import com.github.pfmiles.dropincc.impl.util.Util;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DotGenerator {
    private Collection<GeneratingState> states = null;
    private static String graphTemp = "digraph {0} '{'\nrankdir=LR;\nsize=\"{1},{2}\"\nnode [shape = doublecircle]; {3};\nnode [shape = circle];\n{4}\n'}'\n";
    private static String transitionTemp = "{0} -> {1} [ label = \"{2}\" ];";

    public DotGenerator(Collection<GeneratingState> states) {
        this.states = states;
    }

    public String toDotString(String name, int length, int width) {
        ArrayList<String> finals = new ArrayList<String>();
        ArrayList<String[]> transitions = new ArrayList<String[]>();
        for (GeneratingState state : this.states) {
            if (state.isFinal()) {
                finals.add(state.getId());
            }
            for (Pair<String, GeneratingState> trans : state.getTransitions()) {
                transitions.add(new String[]{state.getId(), trans.getRight().getId(), trans.getLeft()});
            }
        }
        String finalsStr = Util.join(" ", finals);
        String transitionsStr = Util.join("\n", this.renderTransitionStrs(transitions));
        return MessageFormat.format(graphTemp, name, String.valueOf(length), String.valueOf(width), finalsStr, transitionsStr);
    }

    private List<String> renderTransitionStrs(List<String[]> transitions) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String[] trans : transitions) {
            trans[2] = trans[2].replaceAll("\\\"", "\\");
            ret.add(MessageFormat.format(transitionTemp, trans));
        }
        return ret;
    }
}

