/*
 * Decompiled with CFR 0.152.
 */
package com.github.pfmiles.dropincc.impl.automataview;

import com.github.pfmiles.dropincc.impl.automataview.GeneratingState;
import com.github.pfmiles.dropincc.impl.llstar.AtnState;
import com.github.pfmiles.dropincc.impl.llstar.DfaState;
import com.github.pfmiles.dropincc.impl.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class DotAdaptors {
    private DotAdaptors() {
    }

    public static Collection<GeneratingState> adaptAtnStates(Set<AtnState> states) {
        ArrayList<GeneratingState> ret = new ArrayList<GeneratingState>();
        for (AtnState state : states) {
            ret.add(new DotAtnState(state));
        }
        return ret;
    }

    public static Collection<GeneratingState> adaptLookAheadDfaStates(Set<DfaState> states) {
        ArrayList<GeneratingState> ret = new ArrayList<GeneratingState>();
        for (DfaState state : states) {
            ret.add(new DotDfaState(state));
        }
        return ret;
    }

    private static final class DotDfaState
    implements GeneratingState {
        private DfaState state;

        public DotDfaState(DfaState state) {
            this.state = state;
        }

        @Override
        public String getId() {
            if (this.state.isFinal()) {
                return this.state.getName() + "_" + this.state.getAlt();
            }
            return this.state.getName();
        }

        @Override
        public List<Pair<String, GeneratingState>> getTransitions() {
            ArrayList<Pair<String, GeneratingState>> ret = new ArrayList<Pair<String, GeneratingState>>();
            for (Map.Entry<Object, DfaState> e : this.state.getTransitions().entrySet()) {
                ret.add(new Pair<String, DotDfaState>(e.getKey().toString(), new DotDfaState(e.getValue())));
            }
            return ret;
        }

        @Override
        public boolean isFinal() {
            return this.state.isFinal();
        }
    }

    private static final class DotAtnState
    implements GeneratingState {
        private AtnState state;

        public DotAtnState(AtnState state) {
            this.state = state;
        }

        @Override
        public String getId() {
            return this.state.getName();
        }

        @Override
        public List<Pair<String, GeneratingState>> getTransitions() {
            ArrayList<Pair<String, GeneratingState>> ret = new ArrayList<Pair<String, GeneratingState>>();
            for (Pair<Object, AtnState> p : this.state.getTransitionsAsPairs()) {
                ret.add(new Pair<String, DotAtnState>(p.getLeft().toString(), new DotAtnState(p.getRight())));
            }
            return ret;
        }

        @Override
        public boolean isFinal() {
            return this.state.isFinal();
        }
    }
}

