/*
 * Decompiled with CFR 0.152.
 */
package com.github.pfmiles.dropincc.impl;

import com.github.pfmiles.dropincc.DropinccException;
import com.github.pfmiles.dropincc.Element;
import com.github.pfmiles.dropincc.Grule;
import com.github.pfmiles.dropincc.Predicate;
import com.github.pfmiles.dropincc.impl.Alternative;
import com.github.pfmiles.dropincc.impl.util.Util;
import java.util.List;

public class ConstructingGrule
implements Element {
    private static final long serialVersionUID = 2757268497271642042L;
    private Grule grule;

    public ConstructingGrule(Grule grule) {
        this.grule = grule;
    }

    public Grule getGrule() {
        return this.grule;
    }

    public ConstructingGrule alt(Object ... eles) {
        if (eles == null || eles.length == 0) {
            throw new DropinccException("Could not add empty grammar rule, if you want to add a rule alternative that matches nothing, use CC.NOTHING.");
        }
        Element[] elements = Util.filterProductionEles(eles);
        this.grule.getAlts().add(new Alternative(elements));
        return this;
    }

    public ConstructingGrule action(Object action) {
        List<Alternative> alts = this.grule.getAlts();
        Alternative alt = alts.get(alts.size() - 1);
        if (alt.getAction() != null) {
            throw new DropinccException("Any alternative could have one and only one action.");
        }
        alt.setAction(action);
        return this;
    }

    public ConstructingGrule pred(Predicate<?> pred) {
        List<Alternative> alts = this.grule.getAlts();
        Alternative alt = alts.get(alts.size() - 1);
        if (alt.getPred() != null) {
            throw new DropinccException("Any alternative could have one and only one predicate.");
        }
        alt.setPred(pred);
        return this;
    }
}

