/*
 * Decompiled with CFR 0.152.
 */
package com.github.pfmiles.dropincc.impl;

import com.github.pfmiles.dropincc.CC;
import com.github.pfmiles.dropincc.DropinccException;
import com.github.pfmiles.dropincc.Element;
import com.github.pfmiles.dropincc.Grule;
import com.github.pfmiles.dropincc.TokenDef;
import com.github.pfmiles.dropincc.impl.CAlternative;
import com.github.pfmiles.dropincc.impl.EleType;
import com.github.pfmiles.dropincc.impl.GruleType;
import com.github.pfmiles.dropincc.impl.SpecialType;
import com.github.pfmiles.dropincc.impl.TokenType;
import com.github.pfmiles.dropincc.impl.TypeMappingParam;
import com.github.pfmiles.dropincc.impl.hotcompile.CompilationResult;
import com.github.pfmiles.dropincc.impl.hotcompile.HotCompileUtil;
import com.github.pfmiles.dropincc.impl.kleene.AbstractKleeneNode;
import com.github.pfmiles.dropincc.impl.kleene.KleeneCompiler;
import com.github.pfmiles.dropincc.impl.kleene.KleeneType;
import com.github.pfmiles.dropincc.impl.lexical.LexerCompiler;
import com.github.pfmiles.dropincc.impl.llstar.GenedKleeneGruleType;
import com.github.pfmiles.dropincc.impl.llstar.PredictingGrule;
import com.github.pfmiles.dropincc.impl.llstar.PredictingKleene;
import com.github.pfmiles.dropincc.impl.runtime.impl.Lexer;
import com.github.pfmiles.dropincc.impl.runtime.impl.LexerPrototype;
import com.github.pfmiles.dropincc.impl.runtime.impl.Parser;
import com.github.pfmiles.dropincc.impl.runtime.impl.ParserPrototype;
import com.github.pfmiles.dropincc.impl.runtime.impl.PreWrittenStringLexerPrototype;
import com.github.pfmiles.dropincc.impl.runtime.impl.StatelessParserPrototype;
import com.github.pfmiles.dropincc.impl.syntactical.GenedGruleType;
import com.github.pfmiles.dropincc.impl.syntactical.ParserCompiler;
import com.github.pfmiles.dropincc.impl.syntactical.PredictingResult;
import com.github.pfmiles.dropincc.impl.syntactical.codegen.ParserCodeGenResult;
import com.github.pfmiles.dropincc.impl.util.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class AnalyzedLang {
    private String langName;
    private List<TokenDef> tokens;
    private List<Grule> grules;
    private GruleType startRuleType;
    private Map<TokenDef, TokenType> tokenTypeMapping;
    private Map<Grule, GruleType> gruleTypeMapping;
    private static final Map<Element, SpecialType> specialTypeMapping = new HashMap<Element, SpecialType>();
    private Map<Integer, TokenType> groupNumToType;
    private Pattern tokenPatterns;
    private boolean whitespaceSensitive;
    private Map<GruleType, List<CAlternative>> ruleTypeToAlts;
    private Map<AbstractKleeneNode, KleeneType> kleeneTypeMapping;
    private Map<KleeneType, List<EleType>> kleeneTypeToNode;
    private List<PredictingGrule> predGrules;
    private List<PredictingKleene> predKleenes;
    private LexerPrototype lexerPrototype;
    private String parserCode;
    private ParserPrototype parserPrototype;
    private String debugMsgs;
    private String warnings;

    public AnalyzedLang(String name, List<TokenDef> tokens, List<Grule> grules, boolean whitespaceSensitive) {
        this.langName = name;
        this.tokens = tokens;
        this.tokens.addAll(LexerCompiler.collectInstantTokenDefs(grules));
        this.whitespaceSensitive = whitespaceSensitive;
        this.tokenTypeMapping = LexerCompiler.buildTokenTypeMapping(tokens, whitespaceSensitive);
        this.grules = grules;
        List<Grule> genGrules = ParserCompiler.rewriteSubRules(this.grules);
        this.gruleTypeMapping = ParserCompiler.buildGruleTypeMapping(this.grules, genGrules);
        this.kleeneTypeMapping = KleeneCompiler.buildKleeneTypeMapping(this.gruleTypeMapping);
    }

    public void compile() {
        Pair<Map<Integer, TokenType>, Pattern> compiledTokenUnit = LexerCompiler.checkAndCompileTokenRules(this.tokens, this.tokenTypeMapping);
        this.groupNumToType = compiledTokenUnit.getLeft();
        this.tokenPatterns = compiledTokenUnit.getRight();
        TypeMappingParam typeMappingParam = new TypeMappingParam(this.tokenTypeMapping, this.gruleTypeMapping, specialTypeMapping, this.kleeneTypeMapping);
        this.ruleTypeToAlts = ParserCompiler.buildRuleTypeToAlts(typeMappingParam);
        this.kleeneTypeToNode = KleeneCompiler.buildKleeneTypeToNode(typeMappingParam);
        this.startRuleType = this.resolveStartGruleType(this.ruleTypeToAlts, this.kleeneTypeToNode);
        ParserCompiler.checkAndReportLeftRecursions(this.ruleTypeToAlts, this.kleeneTypeToNode);
        PredictingResult predResults = ParserCompiler.computePredictingGrules(this.ruleTypeToAlts, this.kleeneTypeToNode);
        this.predGrules = predResults.getPgs();
        this.predKleenes = predResults.getPks();
        this.debugMsgs = predResults.getDebugMsgs();
        this.warnings = predResults.getWarnings();
        this.lexerPrototype = new PreWrittenStringLexerPrototype(this.groupNumToType, this.tokenPatterns, this.whitespaceSensitive);
        ParserCodeGenResult parserCodeGenResult = ParserCompiler.genParserCode(this.langName, this.startRuleType, this.predGrules, this.predKleenes, this.tokenTypeMapping.values(), this.kleeneTypeToNode);
        this.parserCode = parserCodeGenResult.getCode();
        CompilationResult result = HotCompileUtil.compile("com.github.pfmiles.dropincc.impl.runtime.gen." + this.langName, this.parserCode);
        if (!result.isSucceed()) {
            throw new DropinccException("Parser code compilation failed. Reason: " + result.getErrMsg());
        }
        this.parserPrototype = new StatelessParserPrototype(result.getCls(), parserCodeGenResult);
    }

    private GruleType resolveStartGruleType(Map<GruleType, List<CAlternative>> ruleTypeToAlts, Map<KleeneType, List<EleType>> kleeneTypeToNode) {
        HashSet<GruleType> allGs = new HashSet<GruleType>();
        for (GruleType t : ruleTypeToAlts.keySet()) {
            if (t instanceof GenedGruleType || t instanceof GenedKleeneGruleType) continue;
            allGs.add(t);
        }
        HashSet<GruleType> enteredGrule = new HashSet<GruleType>();
        for (Map.Entry<GruleType, List<CAlternative>> e : ruleTypeToAlts.entrySet()) {
            GruleType g = e.getKey();
            List<CAlternative> alts = e.getValue();
            if (enteredGrule.contains(g)) continue;
            enteredGrule.add(g);
            for (CAlternative alt : alts) {
                this.filterOutInvokedGrule(alt.getMatchSequence(), allGs, ruleTypeToAlts, kleeneTypeToNode, enteredGrule);
            }
        }
        if (allGs.isEmpty()) {
            throw new DropinccException("No start rule found, please check your grammar rules.");
        }
        if (allGs.size() > 1) {
            throw new DropinccException("More than one suspected start rule found in the grammar, dangling rules may exist, please check your grammar rules. These rules are not invoked by others: " + allGs);
        }
        return (GruleType)allGs.iterator().next();
    }

    private void filterOutInvokedGrule(List<EleType> matchSequence, Set<GruleType> allGs, Map<GruleType, List<CAlternative>> ruleTypeToAlts, Map<KleeneType, List<EleType>> kleeneTypeToNode, Set<GruleType> enteredGrule) {
        for (EleType ele : matchSequence) {
            if (ele instanceof TokenType) continue;
            if (ele instanceof GruleType) {
                allGs.remove((GruleType)ele);
                if (enteredGrule.contains((GruleType)ele)) continue;
                enteredGrule.add((GruleType)ele);
                for (CAlternative alt : ruleTypeToAlts.get((GruleType)ele)) {
                    this.filterOutInvokedGrule(alt.getMatchSequence(), allGs, ruleTypeToAlts, kleeneTypeToNode, enteredGrule);
                }
                continue;
            }
            if (ele instanceof KleeneType) {
                this.filterOutInvokedGrule(kleeneTypeToNode.get((KleeneType)ele), allGs, ruleTypeToAlts, kleeneTypeToNode, enteredGrule);
                continue;
            }
            throw new DropinccException("Unhandled element type when finding start rule: " + ele);
        }
    }

    public Lexer newLexer(String code) {
        return this.lexerPrototype.create(code);
    }

    public Parser newParser(Lexer lexer) {
        return this.parserPrototype.create(lexer);
    }

    public Map<TokenDef, TokenType> getTokenTypeMapping() {
        return this.tokenTypeMapping;
    }

    public Map<Grule, GruleType> getGruleTypeMapping() {
        return this.gruleTypeMapping;
    }

    public Map<KleeneType, List<EleType>> getKleeneTypeToNode() {
        return this.kleeneTypeToNode;
    }

    public Map<Integer, TokenType> getGroupNumToType() {
        return this.groupNumToType;
    }

    public Map<GruleType, List<CAlternative>> getRuleTypeToAlts() {
        return this.ruleTypeToAlts;
    }

    public Pattern getTokenPatterns() {
        return this.tokenPatterns;
    }

    public String getDebugMsgs() {
        return this.debugMsgs;
    }

    public String getWarnings() {
        return this.warnings;
    }

    static {
        specialTypeMapping.put(CC.NOTHING, SpecialType.NOTHING);
    }
}

