/*
 * Decompiled with CFR 0.152.
 */
package com.github.pfmiles.dropincc.impl;

import com.github.pfmiles.dropincc.DropinccException;
import com.github.pfmiles.dropincc.Element;
import com.github.pfmiles.dropincc.Predicate;
import java.util.ArrayList;
import java.util.List;

public class Alternative {
    private List<Element> elements = new ArrayList<Element>();
    private Object action = null;
    private Predicate<?> pred;

    public Alternative(Element[] eles) {
        switch (this.checkNull(eles)) {
            case 0: {
                break;
            }
            case 1: {
                throw new DropinccException("Null elements among non-null ones, something must be wrong.");
            }
            case 2: {
                for (Element e : eles) {
                    this.elements.add(e);
                }
                break;
            }
            default: {
                throw new DropinccException("Impossible.");
            }
        }
    }

    private int checkNull(Element[] eles) {
        int nullCount = 0;
        for (Element ele : eles) {
            if (ele != null) continue;
            ++nullCount;
        }
        if (nullCount == eles.length) {
            return 0;
        }
        if (nullCount != 0 && nullCount < eles.length) {
            return 1;
        }
        if (nullCount == 0) {
            return 2;
        }
        return -1;
    }

    public Object getAction() {
        return this.action;
    }

    public void setAction(Object action) {
        this.action = action;
    }

    public List<Element> getElements() {
        return this.elements;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public Predicate<?> getPred() {
        return this.pred;
    }

    public void setPred(Predicate<?> pred) {
        this.pred = pred;
    }
}

