/*
 * Decompiled with CFR 0.152.
 */
package com.github.pfmiles.dropincc;

import com.github.pfmiles.dropincc.DropinccException;
import com.github.pfmiles.dropincc.Element;
import com.github.pfmiles.dropincc.Exe;
import com.github.pfmiles.dropincc.Grule;
import com.github.pfmiles.dropincc.TokenDef;
import com.github.pfmiles.dropincc.impl.Alternative;
import com.github.pfmiles.dropincc.impl.AnalyzedLang;
import com.github.pfmiles.dropincc.impl.ConstructingGrule;
import com.github.pfmiles.dropincc.impl.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class Lang
implements Serializable {
    private static final long serialVersionUID = 631738160652653120L;
    private String name;
    private Pattern langNamePattern = Pattern.compile("^[a-zA-Z]\\w*$");
    private boolean whiteSpaceSensitive;
    private List<TokenDef> tokens = new ArrayList<TokenDef>();
    private List<Grule> grules = new ArrayList<Grule>();
    private String debugMsgs;
    private String warnings;

    public Lang(String name) {
        if (name == null) {
            throw new DropinccException("Language name could not be null.");
        }
        if (!this.langNamePattern.matcher(name).matches()) {
            throw new DropinccException("Language name should be a valid identifier name in java(Start by a character, followed by arbitrary numbers of digit or character).");
        }
        this.name = name;
    }

    public TokenDef newToken(String regExpr) {
        TokenDef t = new TokenDef(regExpr);
        this.tokens.add(t);
        return t;
    }

    public ConstructingGrule defineGrule(Object ... eles) {
        if (eles == null || eles.length == 0) {
            throw new DropinccException("Could not add empty grammar rule, if you want to add a rule alternative that matches nothing, use CC.NOTHING.");
        }
        Grule g = new Grule(this.grules.size());
        Element[] elements = Util.filterProductionEles(eles);
        g.getAlts().add(new Alternative(elements));
        this.grules.add(g);
        return new ConstructingGrule(g);
    }

    public Exe compile() {
        this.checkIfAnyEmptyGrule(this.grules);
        AnalyzedLang cl = new AnalyzedLang(this.name, this.tokens, this.grules, this.whiteSpaceSensitive);
        cl.compile();
        this.debugMsgs = cl.getDebugMsgs();
        this.warnings = cl.getWarnings();
        return new Exe(cl);
    }

    private void checkIfAnyEmptyGrule(List<Grule> gs) {
        for (Grule g : gs) {
            List<Alternative> alts = g.getAlts();
            if (alts != null && !alts.isEmpty()) continue;
            throw new DropinccException("Grule: " + g + " has no alternative production. Do you forget to define them?");
        }
    }

    public boolean isWhiteSpaceSensitive() {
        return this.whiteSpaceSensitive;
    }

    public void setWhiteSpaceSensitive(boolean whiteSpaceSensitive) {
        this.whiteSpaceSensitive = whiteSpaceSensitive;
    }

    public String toString() {
        return "Lang []";
    }

    public Grule newGrule() {
        Grule g = new Grule(this.grules.size());
        this.grules.add(g);
        return g;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public String getDebugMsgs() {
        return this.debugMsgs;
    }

    public String getWarnings() {
        return this.warnings;
    }
}

