/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonzou.jmockdata.mocker;

import com.github.jsonzou.jmockdata.DataConfig;
import com.github.jsonzou.jmockdata.MockException;
import com.github.jsonzou.jmockdata.Mocker;
import com.github.jsonzou.jmockdata.annotation.MockIgnore;
import com.github.jsonzou.jmockdata.mocker.BaseMocker;
import com.github.jsonzou.jmockdata.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;

public class BeanMocker
implements Mocker<Object> {
    private final Class clazz;

    BeanMocker(Class clazz) {
        this.clazz = clazz;
    }

    @Override
    public Object mock(DataConfig mockConfig) {
        try {
            Object cacheBean;
            if (mockConfig.globalConfig().isEnabledCircle() && (cacheBean = mockConfig.globalConfig().getcacheBean(this.clazz.getName())) != null) {
                return cacheBean;
            }
            Object result = this.clazz.newInstance();
            mockConfig.globalConfig().cacheBean(this.clazz.getName(), result);
            if (mockConfig.globalConfig().isConfigExcludeMock(this.clazz)) {
                return result;
            }
            for (Class currentClass = this.clazz; currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
                for (Map.Entry<Field, Method> entry : ReflectionUtils.fieldAndSetterMethod(currentClass).entrySet()) {
                    Field field = entry.getKey();
                    if (field.isAnnotationPresent(MockIgnore.class) || mockConfig.globalConfig().isConfigExcludeMock(this.clazz, field.getName())) continue;
                    ReflectionUtils.setRefValue(result, entry.getValue(), new BaseMocker(field.getGenericType(), new Type[0]).mock(mockConfig.globalConfig().getDataConfig(currentClass, field.getName())));
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new MockException(e);
        }
    }
}

