/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.PrestoExtendedFileSystemCache;

public class HadoopExtendedFileSystemCache {
    private static PrestoExtendedFileSystemCache cache;

    private HadoopExtendedFileSystemCache() {
    }

    public static synchronized void initialize() {
        if (cache == null) {
            cache = HadoopExtendedFileSystemCache.setFinalStatic(FileSystem.class, "CACHE", new PrestoExtendedFileSystemCache());
        }
    }

    private static <T> T setFinalStatic(Class<?> clazz, String name, T value) {
        try {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            Field modifiersField = HadoopExtendedFileSystemCache.getModifiersField();
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.set(null, value);
            return value;
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static Field getModifiersField() throws NoSuchFieldException {
        try {
            return Field.class.getDeclaredField("modifiers");
        }
        catch (NoSuchFieldException e) {
            try {
                Field[] fields;
                Method getDeclaredFields0 = Class.class.getDeclaredMethod("getDeclaredFields0", Boolean.TYPE);
                getDeclaredFields0.setAccessible(true);
                for (Field field : fields = (Field[])getDeclaredFields0.invoke(Field.class, false)) {
                    if (!"modifiers".equals(field.getName())) continue;
                    return field;
                }
            }
            catch (ReflectiveOperationException ex) {
                e.addSuppressed(ex);
            }
            throw e;
        }
    }
}

