/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder.schema;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;

public class OptionsUtils {
    @NonNull
    public static String buildOptions(@NonNull Map<String, Object> options, boolean first) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, Object> option : options.entrySet()) {
            if (first) {
                builder.append(" WITH ");
                first = false;
            } else {
                builder.append(" AND ");
            }
            String value = OptionsUtils.extractOptionValue(option.getValue());
            builder.append(option.getKey()).append("=").append(value);
        }
        return builder.toString();
    }

    @NonNull
    private static String extractOptionValue(@NonNull Object option) {
        StringBuilder optionValue = new StringBuilder();
        if (option instanceof String) {
            optionValue.append("'").append((String)option).append("'");
        } else if (option instanceof Map) {
            Map optionMap = (Map)option;
            boolean first = true;
            optionValue.append("{");
            for (Map.Entry subOption : optionMap.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    optionValue.append(",");
                }
                optionValue.append("'").append((String)subOption.getKey()).append("':").append(OptionsUtils.extractOptionValue(subOption.getValue()));
            }
            optionValue.append("}");
        } else {
            optionValue.append(option);
        }
        return optionValue.toString();
    }
}

