/*
 * Decompiled with CFR 0.152.
 */
package com.dahuatech.h8900.oauth.profile;

import com.dahuatech.hutool.core.util.CharsetUtil;
import com.dahuatech.hutool.core.util.StrUtil;
import com.dahuatech.hutool.http.ContentType;
import com.dahuatech.hutool.http.HttpRequest;
import com.dahuatech.hutool.http.HttpResponse;
import com.dahuatech.hutool.http.Method;
import com.dahuatech.hutool.json.JSONObject;
import com.dahuatech.hutool.json.JSONUtil;
import com.dahuatech.hutool.log.Log;
import com.dahuatech.hutool.log.LogFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class H8900Profile {
    private static final Log logger = LogFactory.get();
    public static volatile Map<String, String> systemVersionMap = new ConcurrentHashMap<String, String>();
    public static volatile boolean inited = Boolean.FALSE;
    public static String host;
    public static String port;
    public static String username;
    public static String password;
    public static Boolean isHttps;
    public static Boolean network;
    public static String HTTPS_PROTOCOL;
    public static String URL_SCHEME;
    public static String HTTP_PROTOCOL;
    private final String CONFIG_HTTPS = "h8900.https";
    private volatile Properties configuration = new Properties();

    private H8900Profile() {
        this.init();
    }

    public static synchronized H8900Profile getInstance() {
        return ConfigurationHolder.configuration;
    }

    public synchronized void init() {
        if (inited) {
            return;
        }
        inited = true;
        this.loadEnvConfig();
        this.initSystemVersion();
    }

    private void loadEnvConfig() {
        this.loadH8900SdkProperties();
        String configHttps = "";
        configHttps = this.configuration.containsKey("h8900.https") ? this.configuration.getProperty("h8900.https") : System.getProperty("h8900.https");
        if (StrUtil.isNotBlank((CharSequence)configHttps) && "false".equalsIgnoreCase(configHttps)) {
            isHttps = Boolean.FALSE;
        }
        String sdkHost = "h8900.host";
        if (StrUtil.isBlank((CharSequence)host) && this.configuration.containsKey(sdkHost)) {
            host = this.configuration.getProperty(sdkHost);
        } else if (StrUtil.isBlank((CharSequence)host)) {
            host = System.getProperty(sdkHost);
        }
        String sdkPost = "h8900.port";
        if (StrUtil.isBlank((CharSequence)port) && this.configuration.containsKey(sdkPost)) {
            port = this.configuration.getProperty(sdkPost);
        } else if (StrUtil.isBlank((CharSequence)port)) {
            port = System.getProperty(sdkHost);
        }
        String sdkUsername = "h8900.username";
        if (StrUtil.isBlank((CharSequence)username) && this.configuration.containsKey(sdkUsername)) {
            username = this.configuration.getProperty(sdkUsername);
        } else if (StrUtil.isBlank((CharSequence)username)) {
            username = System.getProperty(sdkUsername);
        }
        String sdkPassword = "h8900.password";
        if (StrUtil.isBlank((CharSequence)password) && this.configuration.containsKey(sdkPassword)) {
            password = this.configuration.getProperty(sdkPassword);
        } else if (StrUtil.isBlank((CharSequence)password)) {
            password = System.getProperty(sdkPassword);
        }
    }

    private void loadH8900SdkProperties() {
        InputStream is = this.getClass().getResourceAsStream("/config/h8900.properties");
        if (is != null) {
            try {
                this.configuration.clear();
                this.configuration.load(is);
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    is.close();
                }
                catch (Throwable throwable) {}
            }
        } else {
            logger.info("can not load [classpath:resources/config/h8900.properties] , use DefaultClient constructor instead ", new Object[0]);
        }
    }

    private void initSystemVersion() {
        String path = "/WPMS/getPublicKey";
        String url = HTTP_PROTOCOL + host + path;
        try {
            String resultBody;
            JSONObject obj;
            HttpRequest request = new HttpRequest(url).method(Method.POST);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("loginName", username);
            request.body(JSONUtil.toJsonStr(map));
            request.timeout(80000);
            request.setReadTimeout(80000);
            request.contentType(ContentType.JSON.toString(CharsetUtil.CHARSET_UTF_8));
            HttpResponse result = request.execute();
            if (result.getStatus() == 200 && (obj = JSONUtil.parseObj((String)(resultBody = result.body()))) != null && obj.containsKey((Object)"success") && "true".equals(obj.getStr((Object)"success"))) {
                isHttps = Boolean.FALSE;
                network = Boolean.TRUE;
                URL_SCHEME = HTTP_PROTOCOL + host + ":" + port;
                logger.info("check h8900 network success!  host [{}] ,use http", new Object[]{host});
                return;
            }
        }
        catch (Exception e) {
            logger.debug("check h8900 https error {}", new Object[]{host});
            e.printStackTrace();
        }
    }

    static {
        isHttps = Boolean.TRUE;
        network = Boolean.FALSE;
        HTTPS_PROTOCOL = "https://";
        URL_SCHEME = null;
        HTTP_PROTOCOL = "http://";
    }

    private static class ConfigurationHolder {
        private static H8900Profile configuration = new H8900Profile();

        private ConfigurationHolder() {
        }
    }
}

