/*
 * Decompiled with CFR 0.152.
 */
package com.dahuatech.h8900.oauth.http;

import com.dahuatech.h8900.oauth.handle.TokenHandleSingle;
import com.dahuatech.h8900.oauth.http.AbstractIClient;
import com.dahuatech.h8900.oauth.http.H8900HttpRequest;
import com.dahuatech.h8900.oauth.http.H8900Response;
import com.dahuatech.h8900.oauth.http.H8900Token;
import com.dahuatech.h8900.oauth.profile.H8900Profile;
import com.dahuatech.h8900.oauth.unmarshaller.JsonUnmashaller;
import com.dahuatech.h8900.oauth.unmarshaller.Unmarshaller;
import com.dahuatech.hutool.core.util.CharsetUtil;
import com.dahuatech.hutool.core.util.StrUtil;
import com.dahuatech.hutool.http.HttpResponse;
import com.dahuatech.hutool.http.HttpUtil;
import com.dahuatech.hutool.json.JSONUtil;
import com.dahuatech.hutool.log.Log;
import com.dahuatech.hutool.log.LogFactory;
import com.dahuatech.icc.exception.ClientException;
import com.dahuatech.icc.exception.ServerException;
import java.nio.charset.Charset;

public class DefaultClient
extends AbstractIClient {
    private static final Log logger = LogFactory.get();
    private TokenHandleSingle tokenHandleSingle;
    private Unmarshaller unmarshaller;

    public DefaultClient() throws ClientException {
        H8900Profile.getInstance().init();
        this.tokenHandleSingle = TokenHandleSingle.getInstance();
        this.unmarshaller = new JsonUnmashaller();
    }

    public DefaultClient(String host, String username, String password) throws ClientException {
        this.init(host, username, password);
    }

    private void init(String host, String username, String password) {
        if (H8900Profile.inited && !H8900Profile.host.equals(host)) {
            TokenHandleSingle.getInstance().getTokenMap().clear();
        }
        H8900Profile.host = host;
        H8900Profile.password = password;
        H8900Profile.username = username;
        H8900Profile.inited = Boolean.FALSE;
        H8900Profile.getInstance().init();
        this.tokenHandleSingle = TokenHandleSingle.getInstance();
        this.unmarshaller = new JsonUnmashaller();
    }

    @Override
    public String doAction(H8900HttpRequest request) throws ClientException, ServerException {
        H8900HttpRequest iccHttpRequest = this.signRequest(request);
        HttpResponse httpResponse = iccHttpRequest.executeResponse();
        String httpResult = httpResponse.body();
        if (logger.isDebugEnabled()) {
            logger.debug("requestUrl=[{}],method=[{}],params=[{}],result=[{}]", new Object[]{request.getUrl(), request.getMethod(), StrUtil.isBlank((CharSequence)request.getBody()) ? request.getForm() : request.getBody(), httpResult});
        }
        return httpResult;
    }

    @Override
    public <T extends H8900Response> T doAction(H8900HttpRequest request, Class<T> tClass) throws ClientException, ServerException {
        H8900HttpRequest iccHttpRequest = this.signRequest(request);
        HttpResponse httpResult = iccHttpRequest.executeResponse();
        String result = httpResult.body();
        if (logger.isDebugEnabled()) {
            logger.debug("requestUrl=[{}],method=[{}],params=[{}],result=[{}]", new Object[]{request.getUrl(), request.getMethod(), StrUtil.isBlank((CharSequence)request.getBody()) ? request.getForm() : request.getBody(), result});
        }
        T t = this.unmarshal(tClass, result);
        ((H8900Response)t).setResult(result);
        return t;
    }

    @Override
    public synchronized H8900Token getAccessToken() {
        H8900Token token = this.tokenHandleSingle.getTokenCache();
        if (token != null) {
            return token;
        }
        token = this.tokenHandleSingle.refreshToken();
        return token;
    }

    @Override
    H8900HttpRequest signRequest(H8900HttpRequest request) {
        if (request.isNeedAuth()) {
            H8900Token token = this.getAccessToken();
            request.setUrl(HttpUtil.urlWithForm((String)request.getUrl(), token.getParam(), (Charset)CharsetUtil.CHARSET_UTF_8, (boolean)false));
            request.header("token", token.getToken());
            request.header("accessToken", token.getIpmsAccessToken());
        }
        if (request.getBodyParameters().size() > 0 && StrUtil.isBlank((CharSequence)request.getBody())) {
            request.body(JSONUtil.toJsonStr(request.getBodyParameters()));
        }
        return request;
    }

    @Override
    public <T extends H8900Response> T unmarshal(Class<T> clasz, String content) throws ClientException {
        return this.unmarshaller.unmarshal(clasz, content);
    }
}

