/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.log.thirdparty.org.apache.http.protocol;

import com.aliyun.log.thirdparty.org.apache.http.HttpEntity;
import com.aliyun.log.thirdparty.org.apache.http.HttpEntityEnclosingRequest;
import com.aliyun.log.thirdparty.org.apache.http.HttpException;
import com.aliyun.log.thirdparty.org.apache.http.HttpRequest;
import com.aliyun.log.thirdparty.org.apache.http.HttpRequestInterceptor;
import com.aliyun.log.thirdparty.org.apache.http.HttpVersion;
import com.aliyun.log.thirdparty.org.apache.http.ProtocolException;
import com.aliyun.log.thirdparty.org.apache.http.ProtocolVersion;
import com.aliyun.log.thirdparty.org.apache.http.annotation.Immutable;
import com.aliyun.log.thirdparty.org.apache.http.protocol.HttpContext;
import com.aliyun.log.thirdparty.org.apache.http.util.Args;
import java.io.IOException;

@Immutable
public class RequestContent
implements HttpRequestInterceptor {
    private final boolean overwrite;

    public RequestContent() {
        this(false);
    }

    public RequestContent(boolean overwrite) {
        this.overwrite = overwrite;
    }

    @Override
    public void process(HttpRequest request2, HttpContext context) throws HttpException, IOException {
        Args.notNull(request2, "HTTP request");
        if (request2 instanceof HttpEntityEnclosingRequest) {
            if (this.overwrite) {
                request2.removeHeaders("Transfer-Encoding");
                request2.removeHeaders("Content-Length");
            } else {
                if (request2.containsHeader("Transfer-Encoding")) {
                    throw new ProtocolException("Transfer-encoding header already present");
                }
                if (request2.containsHeader("Content-Length")) {
                    throw new ProtocolException("Content-Length header already present");
                }
            }
            ProtocolVersion ver = request2.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request2).getEntity();
            if (entity == null) {
                request2.addHeader("Content-Length", "0");
                return;
            }
            if (entity.isChunked() || entity.getContentLength() < 0L) {
                if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                    throw new ProtocolException("Chunked transfer encoding not allowed for " + ver);
                }
                request2.addHeader("Transfer-Encoding", "chunked");
            } else {
                request2.addHeader("Content-Length", Long.toString(entity.getContentLength()));
            }
            if (entity.getContentType() != null && !request2.containsHeader("Content-Type")) {
                request2.addHeader(entity.getContentType());
            }
            if (entity.getContentEncoding() != null && !request2.containsHeader("Content-Encoding")) {
                request2.addHeader(entity.getContentEncoding());
            }
        }
    }
}

