/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.log.thirdparty.org.apache.http.client.protocol;

import com.alibaba.schedulerx.shade.org.apache.commons.logging.Log;
import com.alibaba.schedulerx.shade.org.apache.commons.logging.LogFactory;
import com.aliyun.log.thirdparty.org.apache.http.HttpException;
import com.aliyun.log.thirdparty.org.apache.http.HttpRequest;
import com.aliyun.log.thirdparty.org.apache.http.HttpRequestInterceptor;
import com.aliyun.log.thirdparty.org.apache.http.annotation.Immutable;
import com.aliyun.log.thirdparty.org.apache.http.client.protocol.HttpClientContext;
import com.aliyun.log.thirdparty.org.apache.http.conn.routing.RouteInfo;
import com.aliyun.log.thirdparty.org.apache.http.protocol.HttpContext;
import com.aliyun.log.thirdparty.org.apache.http.util.Args;
import java.io.IOException;

@Immutable
public class RequestClientConnControl
implements HttpRequestInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String PROXY_CONN_DIRECTIVE = "Proxy-Connection";

    @Override
    public void process(HttpRequest request2, HttpContext context) throws HttpException, IOException {
        Args.notNull(request2, "HTTP request");
        String method = request2.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            request2.setHeader(PROXY_CONN_DIRECTIVE, "Keep-Alive");
            return;
        }
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RouteInfo route = clientContext.getHttpRoute();
        if (route == null) {
            this.log.debug("Connection route not set in the context");
            return;
        }
        if ((route.getHopCount() == 1 || route.isTunnelled()) && !request2.containsHeader("Connection")) {
            request2.addHeader("Connection", "Keep-Alive");
        }
        if (route.getHopCount() == 2 && !route.isTunnelled() && !request2.containsHeader(PROXY_CONN_DIRECTIVE)) {
            request2.addHeader(PROXY_CONN_DIRECTIVE, "Keep-Alive");
        }
    }
}

