/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.log.thirdparty.org.apache.commons.beanutils.converters;

import com.aliyun.log.thirdparty.org.apache.commons.beanutils.ConversionException;
import com.aliyun.log.thirdparty.org.apache.commons.beanutils.Converter;
import com.aliyun.log.thirdparty.org.apache.commons.beanutils.converters.AbstractConverter;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class ArrayConverter
extends AbstractConverter {
    private Object defaultTypeInstance;
    private Converter elementConverter;
    private int defaultSize;
    private char delimiter = (char)44;
    private char[] allowedChars = new char[]{'.', '-'};
    private boolean onlyFirstToString = true;
    static /* synthetic */ Class class$java$lang$String;

    public ArrayConverter(Class defaultType, Converter elementConverter) {
        if (defaultType == null) {
            throw new IllegalArgumentException("Default type is missing");
        }
        if (!defaultType.isArray()) {
            throw new IllegalArgumentException("Default type must be an array.");
        }
        if (elementConverter == null) {
            throw new IllegalArgumentException("Component Converter is missing.");
        }
        this.defaultTypeInstance = Array.newInstance(defaultType.getComponentType(), 0);
        this.elementConverter = elementConverter;
    }

    public ArrayConverter(Class defaultType, Converter elementConverter, int defaultSize) {
        this(defaultType, elementConverter);
        this.defaultSize = defaultSize;
        Object defaultValue = null;
        if (defaultSize >= 0) {
            defaultValue = Array.newInstance(defaultType.getComponentType(), defaultSize);
        }
        this.setDefaultValue(defaultValue);
    }

    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    public void setAllowedChars(char[] allowedChars) {
        this.allowedChars = allowedChars;
    }

    public void setOnlyFirstToString(boolean onlyFirstToString) {
        this.onlyFirstToString = onlyFirstToString;
    }

    protected Class getDefaultType() {
        return this.defaultTypeInstance.getClass();
    }

    protected String convertToString(Object value2) throws Throwable {
        int size2 = 0;
        Iterator iterator2 = null;
        Class<?> type = value2.getClass();
        if (type.isArray()) {
            size2 = Array.getLength(value2);
        } else {
            Collection collection = this.convertToCollection(type, value2);
            size2 = collection.size();
            iterator2 = collection.iterator();
        }
        if (size2 == 0) {
            return (String)this.getDefault(class$java$lang$String == null ? (class$java$lang$String = ArrayConverter.class$("java.lang.String")) : class$java$lang$String);
        }
        if (this.onlyFirstToString) {
            size2 = 1;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < size2; ++i) {
            if (i > 0) {
                buffer.append(this.delimiter);
            }
            Object element = iterator2 == null ? Array.get(value2, i) : iterator2.next();
            element = this.elementConverter.convert(class$java$lang$String == null ? ArrayConverter.class$("java.lang.String") : class$java$lang$String, element);
            if (element == null) continue;
            buffer.append(element);
        }
        return buffer.toString();
    }

    protected Object convertToType(Class type, Object value2) throws Throwable {
        if (!type.isArray()) {
            throw new ConversionException(this.toString(this.getClass()) + " cannot handle conversion to '" + this.toString(type) + "' (not an array).");
        }
        int size2 = 0;
        Iterator iterator2 = null;
        if (value2.getClass().isArray()) {
            size2 = Array.getLength(value2);
        } else {
            Collection collection = this.convertToCollection(type, value2);
            size2 = collection.size();
            iterator2 = collection.iterator();
        }
        Class<?> componentType = type.getComponentType();
        Object newArray = Array.newInstance(componentType, size2);
        for (int i = 0; i < size2; ++i) {
            Object element = iterator2 == null ? Array.get(value2, i) : iterator2.next();
            element = this.elementConverter.convert(componentType, element);
            Array.set(newArray, i, element);
        }
        return newArray;
    }

    protected Object convertArray(Object value2) {
        return value2;
    }

    protected Collection convertToCollection(Class type, Object value2) {
        if (value2 instanceof Collection) {
            return (Collection)value2;
        }
        if (value2 instanceof Number || value2 instanceof Boolean || value2 instanceof Date) {
            ArrayList<Object> list = new ArrayList<Object>(1);
            list.add(value2);
            return list;
        }
        return this.parseElements(type, value2.toString());
    }

    protected Object getDefault(Class type) {
        if (type.equals(class$java$lang$String == null ? (class$java$lang$String = ArrayConverter.class$("java.lang.String")) : class$java$lang$String)) {
            return null;
        }
        Object defaultValue = super.getDefault(type);
        if (defaultValue == null) {
            return null;
        }
        if (defaultValue.getClass().equals(type)) {
            return defaultValue;
        }
        return Array.newInstance(type.getComponentType(), this.defaultSize);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.toString(this.getClass()));
        buffer.append("[UseDefault=");
        buffer.append(this.isUseDefault());
        buffer.append(", ");
        buffer.append(this.elementConverter.toString());
        buffer.append(']');
        return buffer.toString();
    }

    private List parseElements(Class type, String value2) {
        if (this.log().isDebugEnabled()) {
            this.log().debug("Parsing elements, delimiter=[" + this.delimiter + "], value=[" + value2 + "]");
        }
        if ((value2 = value2.trim()).startsWith("{") && value2.endsWith("}")) {
            value2 = value2.substring(1, value2.length() - 1);
        }
        try {
            int ttype;
            StreamTokenizer st = new StreamTokenizer(new StringReader(value2));
            st.whitespaceChars(this.delimiter, this.delimiter);
            st.ordinaryChars(48, 57);
            st.wordChars(48, 57);
            for (int i = 0; i < this.allowedChars.length; ++i) {
                st.ordinaryChars(this.allowedChars[i], this.allowedChars[i]);
                st.wordChars(this.allowedChars[i], this.allowedChars[i]);
            }
            List list = null;
            while ((ttype = st.nextToken()) == -3 || ttype > 0) {
                if (st.sval == null) continue;
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(st.sval);
            }
            if (ttype != -1) {
                throw new ConversionException("Encountered token of type " + ttype + " parsing elements to '" + this.toString(type) + ".");
            }
            if (list == null) {
                list = Collections.EMPTY_LIST;
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug(list.size() + " elements parsed");
            }
            return list;
        }
        catch (IOException e) {
            throw new ConversionException("Error converting from String to '" + this.toString(type) + "': " + e.getMessage(), e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

