/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.security;

import com.alibaba.schedulerx.common.domain.JSONResult;
import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.common.util.JsonUtil;
import com.alibaba.schedulerx.shade.com.google.common.collect.Maps;
import com.alibaba.schedulerx.shade.com.mashape.unirest.http.HttpResponse;
import com.alibaba.schedulerx.shade.com.mashape.unirest.http.JsonNode;
import com.alibaba.schedulerx.shade.com.mashape.unirest.http.Unirest;
import com.alibaba.schedulerx.shade.com.mashape.unirest.http.exceptions.UnirestException;
import com.alibaba.schedulerx.shade.com.taobao.spas.sdk.client.SpasSdkClientFacade;
import com.alibaba.schedulerx.shade.com.taobao.spas.sdk.client.identity.Credentials;
import com.alibaba.schedulerx.shade.org.apache.commons.configuration.Configuration;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.StringUtils;
import com.alibaba.schedulerx.worker.exception.AuthenticateException;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.security.Authenticator;
import java.util.HashMap;
import java.util.List;

public class AliyunAuthenticator
implements Authenticator {
    private static final String AUTHENTICATE_DEFAULT = "authenticate_default";
    private static final String AUTHENTICATE_DAUTH = "authenticate_dauth";
    private static final String AUTHENTICATE_RAM = "authenticate_ram";
    private static final String AUTHENTICATE_STS = "authenticate_sts";
    private static final String AUTHENTICATE_URL = "/worker/v1/appgroup/authenticate";
    private static final Logger LOGGER = LogFactory.getLogger(AliyunAuthenticator.class);

    @Override
    public void authenticate(Configuration conf, String namespace, String namespaceSource, List<String> groupIds) throws AuthenticateException {
        JSONResult result2 = JSONResult.geneFailResult();
        String accessKey = "";
        String secretKey = "";
        String secretToken = "";
        String appKeyProperty = System.getProperty("schedulerx.appKey");
        if (StringUtils.isNotBlank(appKeyProperty)) {
            conf.setProperty("appKey", appKeyProperty);
        }
        Object[] appKeys = conf.getStringArray("appKey");
        HashMap<String, Object> parameterMap = Maps.newHashMap();
        if (StringUtils.isNotBlank(namespace)) {
            parameterMap.put("namespace", namespace);
        }
        if (StringUtils.isNotBlank(namespaceSource)) {
            parameterMap.put("namespaceSource", namespaceSource);
        }
        parameterMap.put("groups", StringUtils.join(groupIds, ","));
        if (appKeys != null && appKeys.length > 0) {
            parameterMap.put("accessKey", StringUtils.join(appKeys, ","));
            parameterMap.put("type", AUTHENTICATE_DEFAULT);
        } else {
            if (StringUtils.isNotBlank(conf.getString("aliyun.accessKey"))) {
                accessKey = conf.getString("aliyun.accessKey");
                secretKey = conf.getString("aliyun.secretKey");
                parameterMap.put("type", AUTHENTICATE_RAM);
            } else if (StringUtils.isNotBlank(conf.getString("sts.accessKey"))) {
                accessKey = conf.getString("sts.accessKey");
                secretKey = conf.getString("sts.secretKey");
                secretToken = conf.getString("sts.token");
                parameterMap.put("secretToken", secretToken);
                parameterMap.put("type", AUTHENTICATE_STS);
            } else {
                Credentials credentials = SpasSdkClientFacade.getCredential();
                if (StringUtils.isNotBlank(credentials.getAccessKey())) {
                    accessKey = credentials.getAccessKey();
                }
                if (StringUtils.isNotBlank(credentials.getSecretKey())) {
                    secretKey = credentials.getSecretKey();
                }
                conf.setProperty("schedulerx.worker.source", "edas");
                parameterMap.put("type", AUTHENTICATE_DAUTH);
            }
            if (StringUtils.isBlank(accessKey)) {
                throw new AuthenticateException("ak is blank");
            }
            if (StringUtils.isBlank(secretKey)) {
                throw new AuthenticateException("sk is blank");
            }
            parameterMap.put("accessKey", accessKey);
            parameterMap.put("secretKey", secretKey);
        }
        String domain = ConfigUtil.getWorkerConfig().getString("domainName");
        if (StringUtils.isNotBlank(domain)) {
            String url = "http://" + domain + AUTHENTICATE_URL;
            try {
                HttpResponse<JsonNode> jsonResponse = Unirest.post(url).fields(parameterMap).asJson();
                if (jsonResponse != null) {
                    result2 = JsonUtil.fromJson(jsonResponse.getBody().toString(), JSONResult.class);
                }
            }
            catch (UnirestException e) {
                LOGGER.error("groupIds: {} authenticate error, url={}", groupIds, url, e);
            }
            catch (Exception e) {
                LOGGER.error("groupIds: {} authenticate error, url={}", groupIds, url, e);
            }
        }
        if (result2 != null) {
            if (!result2.isSuccess() || !((Boolean)result2.getData()).booleanValue()) {
                throw new AuthenticateException(result2.getMessage());
            }
        } else {
            throw new AuthenticateException("authenticate result is null");
        }
    }
}

