/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.master.persistence;

import com.alibaba.schedulerx.common.domain.TaskStatus;
import com.alibaba.schedulerx.protocol.Worker;
import com.alibaba.schedulerx.shade.com.google.common.collect.Lists;
import com.alibaba.schedulerx.shade.com.google.protobuf.ByteString;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.StringUtils;
import com.alibaba.schedulerx.worker.domain.TaskStatistics;
import com.alibaba.schedulerx.worker.master.persistence.H2ConnectionPool;
import com.alibaba.schedulerx.worker.master.persistence.TaskSnapshot;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;

public class TaskDao {
    private H2ConnectionPool h2CP;

    public TaskDao(H2ConnectionPool h2CP) {
        this.h2CP = h2CP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTable() throws Exception {
        String sql = "DROP TABLE IF EXISTS task";
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.h2CP.getConnection();
            ps = conn.prepareStatement(sql);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            this.releaseConnection(conn, ps, null);
            throw throwable;
        }
        this.releaseConnection(conn, ps, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTable() throws Exception {
        String sql = "CREATE TABLE IF NOT EXISTS task (job_id bigint(20) unsigned NOT NULL,job_instance_id bigint(20) unsigned NOT NULL,task_id bigint(20) unsigned NOT NULL,task_name varchar(100) NOT NULL DEFAULT '',status int(11) NOT NULL,progress float NOT NULL DEFAULT '0',gmt_create datetime NOT NULL,gmt_modified datetime NOT NULL,worker_addr varchar(30) NOT NULL DEFAULT '',worker_id varchar(30) NOT NULL DEFAULT '',task_body blob DEFAULT NULL,UNIQUE KEY uk_instance_and_task (job_instance_id,task_id),KEY idx_job_instance_id (job_instance_id),KEY idx_status (status))";
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.h2CP.getConnection();
            ps = conn.prepareStatement(sql);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            this.releaseConnection(conn, ps, null);
            throw throwable;
        }
        this.releaseConnection(conn, ps, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insert(long jobId, long jobInstanceId, long taskId, String taskName, ByteString taskBody) throws SQLException {
        int n;
        int result2 = 0;
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.h2CP.getConnection();
            ps = conn.prepareStatement("insert into task(job_id,job_instance_id,task_id,task_name,status,gmt_create,gmt_modified,task_body) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
            ps.setLong(1, jobId);
            ps.setLong(2, jobInstanceId);
            ps.setLong(3, taskId);
            ps.setString(4, taskName);
            ps.setInt(5, TaskStatus.PULLED.getValue());
            ps.setTimestamp(6, new Timestamp(DateTime.now().getMillis()));
            ps.setTimestamp(7, new Timestamp(DateTime.now().getMillis()));
            ps.setBytes(8, taskBody.toByteArray());
            n = result2 = ps.executeUpdate();
        }
        catch (Throwable throwable) {
            this.releaseConnection(conn, ps, null);
            throw throwable;
        }
        this.releaseConnection(conn, ps, null);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int batchInsert(List<Worker.MasterStartContainerRequest> containers, String workerId, String workerAddr) throws SQLException {
        int result2 = 0;
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            int[] counts;
            conn = this.h2CP.getConnection();
            ps = conn.prepareStatement("insert into task(job_id,job_instance_id,task_id,task_name,status,gmt_create,gmt_modified,task_body,worker_id,worker_addr) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            for (Worker.MasterStartContainerRequest snapshot : containers) {
                ps.setLong(1, snapshot.getJobId());
                ps.setLong(2, snapshot.getJobInstanceId());
                ps.setLong(3, snapshot.getTaskId());
                ps.setString(4, snapshot.getTaskName());
                ps.setInt(5, TaskStatus.RUNNING.getValue());
                ps.setTimestamp(6, new Timestamp(DateTime.now().getMillis()));
                ps.setTimestamp(7, new Timestamp(DateTime.now().getMillis()));
                ps.setBytes(8, snapshot.getTask().toByteArray());
                ps.setString(9, workerId);
                ps.setString(10, workerAddr);
                ps.addBatch();
            }
            for (int count2 : counts = ps.executeBatch()) {
                result2 += count2;
            }
        }
        catch (Throwable throwable) {
            this.releaseConnection(conn, ps, null);
            throw throwable;
        }
        this.releaseConnection(conn, ps, null);
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskStatistics getTaskStatistics() throws SQLException {
        TaskStatistics result2 = new TaskStatistics();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.h2CP.getConnection();
            ps = conn.prepareStatement("select count(distinct job_instance_id) from task");
            rs = ps.executeQuery();
            if (rs.next()) {
                result2.setDistinctInstanceCount(rs.getLong(1));
            }
            if ((rs = (ps = conn.prepareStatement("select count(*) from task")).executeQuery()).next()) {
                result2.setTaskCount(rs.getLong(1));
            }
        }
        catch (Throwable throwable) {
            this.releaseConnection(conn, ps, rs);
            throw throwable;
        }
        this.releaseConnection(conn, ps, rs);
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateStatus(long jobInstanceId, long taskId, int status, String workerAddr) throws SQLException {
        int n;
        int result2 = 0;
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.h2CP.getConnection();
            ps = conn.prepareStatement("update task set status=?,worker_addr=?,gmt_modified=? where job_instance_id=? and task_id=?");
            ps.setInt(1, status);
            ps.setString(2, workerAddr);
            ps.setTimestamp(3, new Timestamp(DateTime.now().getMillis()));
            ps.setLong(4, jobInstanceId);
            ps.setLong(5, taskId);
            n = result2 = ps.executeUpdate();
        }
        catch (Throwable throwable) {
            this.releaseConnection(conn, ps, null);
            throw throwable;
        }
        this.releaseConnection(conn, ps, null);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateStatus(long jobInstanceId, List<Long> taskIds, int status, String workerId, String workerAddr) throws SQLException {
        int n;
        int result2 = 0;
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            int[] counts;
            conn = this.h2CP.getConnection();
            String sql = "update task set status=?, worker_id=?, worker_addr=? WHERE job_instance_id=? and task_id =?";
            if (status == TaskStatus.INIT.getValue()) {
                sql = sql + " and status = 3";
            }
            ps = conn.prepareStatement(sql);
            for (Long taskId : taskIds) {
                ps.setInt(1, status);
                ps.setString(2, workerId);
                ps.setString(3, workerAddr);
                ps.setLong(4, jobInstanceId);
                ps.setLong(5, taskId);
                ps.addBatch();
            }
            for (int count2 : counts = ps.executeBatch()) {
                result2 += count2;
            }
            n = result2;
        }
        catch (Throwable throwable) {
            this.releaseConnection(conn, ps, null);
            throw throwable;
        }
        this.releaseConnection(conn, ps, null);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int batchUpdateStatus(long jobInstanceId, List<Long> taskIdList, int status) throws SQLException {
        int n;
        int result2 = 0;
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.h2CP.getConnection();
            String sql = "update task set status=" + status + " where job_instance_id=" + jobInstanceId + " and task_id in (" + StringUtils.join(taskIdList, ",") + ")";
            ps = conn.prepareStatement(sql);
            n = result2 = ps.executeUpdate();
        }
        catch (Throwable throwable) {
            this.releaseConnection(conn, ps, null);
            throw throwable;
        }
        this.releaseConnection(conn, ps, null);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getDistinctInstanceIds() throws SQLException {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<Long> result2 = new ArrayList<Long>();
        try {
            conn = this.h2CP.getConnection();
            ps = conn.prepareStatement("select distinct job_instance_id from task");
            rs = ps.executeQuery();
            while (rs.next()) {
                result2.add(rs.getLong(1));
            }
        }
        catch (Throwable throwable) {
            this.releaseConnection(conn, ps, rs);
            throw throwable;
        }
        this.releaseConnection(conn, ps, rs);
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int batchUpdateStatus(long jobInstanceId, int status, String workerId, String workerAddr) throws SQLException {
        int n;
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            int result2;
            conn = this.h2CP.getConnection();
            String sql = workerId != null ? "update task set status=?,gmt_modified=? where job_instance_id=? and worker_id=? and worker_addr=?" : "update task set status=?,gmt_modified=? where job_instance_id=?";
            if (status == TaskStatus.INIT.getValue()) {
                sql = sql + " and status = 3";
            }
            ps = conn.prepareStatement(sql);
            ps.setInt(1, status);
            ps.setTimestamp(2, new Timestamp(DateTime.now().getMillis()));
            ps.setLong(3, jobInstanceId);
            if (workerId != null) {
                ps.setString(4, workerId);
                ps.setString(5, workerAddr);
            }
            n = result2 = ps.executeUpdate();
        }
        catch (Throwable throwable) {
            this.releaseConnection(conn, ps, null);
            throw throwable;
        }
        this.releaseConnection(conn, ps, null);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateWorker(long jobInstanceId, long taskId, String workerId, String workerAddr) throws SQLException {
        int n;
        int result2 = 0;
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.h2CP.getConnection();
            ps = conn.prepareStatement("update task set worker_id=?,worker_addr=?,gmt_modified=? where job_instance_id=? and task_id=?");
            ps.setString(1, workerId);
            ps.setString(2, workerAddr);
            ps.setTimestamp(3, new Timestamp(DateTime.now().getMillis()));
            ps.setLong(4, jobInstanceId);
            ps.setLong(5, taskId);
            n = result2 = ps.executeUpdate();
        }
        catch (Throwable throwable) {
            this.releaseConnection(conn, ps, null);
            throw throwable;
        }
        this.releaseConnection(conn, ps, null);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaskSnapshot> queryTaskList(long jobInstanceId, int status, int pageSize) throws SQLException {
        ArrayList<TaskSnapshot> arrayList;
        ArrayList<TaskSnapshot> taskSnapshots = Lists.newArrayList();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.h2CP.getConnection();
            ps = conn.prepareStatement("select * from task where job_instance_id=? and status=? limit ?");
            ps.setLong(1, jobInstanceId);
            ps.setInt(2, status);
            ps.setInt(3, pageSize);
            rs = ps.executeQuery();
            while (rs.next()) {
                TaskSnapshot taskSnapshot = this.convert2TaskSnapshot(rs);
                taskSnapshots.add(taskSnapshot);
            }
            arrayList = taskSnapshots;
        }
        catch (Throwable throwable) {
            this.releaseConnection(conn, ps, rs);
            throw throwable;
        }
        this.releaseConnection(conn, ps, rs);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> queryStatus(long jobInstanceId) throws SQLException {
        ArrayList<Integer> arrayList;
        ArrayList<Integer> statusList = Lists.newArrayList();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.h2CP.getConnection();
            ps = conn.prepareStatement("select distinct(status) from task where job_instance_id=?");
            ps.setLong(1, jobInstanceId);
            rs = ps.executeQuery();
            while (rs.next()) {
                statusList.add(rs.getInt(1));
            }
            arrayList = statusList;
        }
        catch (Throwable throwable) {
            this.releaseConnection(conn, ps, rs);
            throw throwable;
        }
        this.releaseConnection(conn, ps, rs);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long queryTaskCount(long jobInstanceId) throws SQLException {
        long l;
        long count2 = 0L;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.h2CP.getConnection();
            ps = conn.prepareStatement("select count(*) from task where job_instance_id=?");
            ps.setLong(1, jobInstanceId);
            rs = ps.executeQuery();
            if (rs.next()) {
                count2 = rs.getLong(1);
            }
            l = count2;
        }
        catch (Throwable throwable) {
            this.releaseConnection(conn, ps, rs);
            throw throwable;
        }
        this.releaseConnection(conn, ps, rs);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exist(long jobInstanceId) throws SQLException {
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        block3: {
            boolean bl;
            conn = null;
            ps = null;
            rs = null;
            try {
                conn = this.h2CP.getConnection();
                ps = conn.prepareStatement("select EXISTS (select * from task where job_instance_id=?)");
                ps.setLong(1, jobInstanceId);
                rs = ps.executeQuery();
                if (!rs.next()) break block3;
                bl = rs.getBoolean(1);
            }
            catch (Throwable throwable) {
                this.releaseConnection(conn, ps, rs);
                throw throwable;
            }
            this.releaseConnection(conn, ps, rs);
            return bl;
        }
        boolean bl = false;
        this.releaseConnection(conn, ps, rs);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteByJobInstanceId(long jobInstanceId) throws SQLException {
        int n;
        int result2 = 0;
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.h2CP.getConnection();
            ps = conn.prepareStatement("delete from task where job_instance_id=?");
            ps.setLong(1, jobInstanceId);
            n = result2 = ps.executeUpdate();
        }
        catch (Throwable throwable) {
            this.releaseConnection(conn, ps, null);
            throw throwable;
        }
        this.releaseConnection(conn, ps, null);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int batchDeleteTasks(long jobInstanceId, List<Long> taskIds) throws SQLException {
        int n;
        int result2 = 0;
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            int[] counts;
            conn = this.h2CP.getConnection();
            String sql = "delete from task where job_instance_id=? and task_id=?";
            ps = conn.prepareStatement(sql);
            for (Long taskId : taskIds) {
                ps.setLong(1, jobInstanceId);
                ps.setLong(2, taskId);
                ps.addBatch();
            }
            for (int count2 : counts = ps.executeBatch()) {
                result2 += count2;
            }
            n = result2;
        }
        catch (Throwable throwable) {
            this.releaseConnection(conn, ps, null);
            throw throwable;
        }
        this.releaseConnection(conn, ps, null);
        return n;
    }

    private void releaseConnection(Connection conn, PreparedStatement ps, ResultSet rs) throws SQLException {
        if (rs != null) {
            rs.close();
        }
        if (ps != null) {
            ps.close();
        }
        if (conn != null) {
            conn.close();
        }
    }

    private TaskSnapshot convert2TaskSnapshot(ResultSet rs) throws SQLException {
        TaskSnapshot taskSnapshot = new TaskSnapshot();
        taskSnapshot.setJob_id(rs.getLong("job_id"));
        taskSnapshot.setJob_instance_id(rs.getLong("job_instance_id"));
        taskSnapshot.setTask_id(rs.getLong("task_id"));
        taskSnapshot.setTask_name(rs.getString("task_name"));
        taskSnapshot.setStatus(rs.getInt("status"));
        taskSnapshot.setProgress(Float.valueOf(rs.getFloat("progress")));
        taskSnapshot.setGmt_create(rs.getDate("gmt_create"));
        taskSnapshot.setGmt_modified(rs.getDate("gmt_modified"));
        taskSnapshot.setTask_body(rs.getBytes("task_body"));
        return taskSnapshot;
    }
}

