/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.actor;

import akka.actor.UntypedActor;
import com.alibaba.schedulerx.common.domain.InstanceStatus;
import com.alibaba.schedulerx.common.util.ExceptionUtil;
import com.alibaba.schedulerx.common.util.IdUtil;
import com.alibaba.schedulerx.protocol.Worker;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.master.MapTaskMaster;
import com.alibaba.schedulerx.worker.master.TaskMaster;
import com.alibaba.schedulerx.worker.master.TaskMasterPool;
import java.util.List;

public class TaskActor
extends UntypedActor {
    private TaskMasterPool masterPool = TaskMasterPool.INSTANCE;
    private static final Logger LOGGER = LogFactory.getLogger(TaskActor.class);

    @Override
    public void onReceive(Object obj) throws Throwable {
        if (obj instanceof Worker.ContainerReportTaskStatusRequest) {
            this.handleTaskStatus((Worker.ContainerReportTaskStatusRequest)obj);
        } else if (obj instanceof Worker.ContainerBatchReportTaskStatuesRequest) {
            this.handleBatchTaskStatues((Worker.ContainerBatchReportTaskStatuesRequest)obj);
        } else if (obj instanceof Worker.WorkerMapTaskRequest) {
            this.handleMapTask((Worker.WorkerMapTaskRequest)obj);
        } else if (obj instanceof Worker.PullTaskFromMasterRequest) {
            this.handlePullTasks((Worker.PullTaskFromMasterRequest)obj);
        }
    }

    private void handleTaskStatus(Worker.ContainerReportTaskStatusRequest request2) {
        try {
            TaskMaster taskMaster = this.masterPool.get(request2.getJobInstanceId());
            LOGGER.debug("handleTaskStatus, uniqueId:{}, status:{}, workerAddr:{}", IdUtil.getUniqueId(request2.getJobId(), request2.getJobInstanceId(), request2.getTaskId()), request2.getStatus(), request2.getWorkerAddr());
            if (taskMaster != null) {
                taskMaster.updateTaskStatus(request2);
            }
        }
        catch (Throwable e) {
            LOGGER.error("jobInstanceId={}, taskId={}", request2.getJobInstanceId(), request2.getTaskId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleBatchTaskStatues(Worker.ContainerBatchReportTaskStatuesRequest request2) {
        LOGGER.info("jobInstanceId={}, batch receive task status reqs, size:{}", request2.getJobInstanceId(), request2.getTaskStatuesCount());
        Worker.ContainerBatchReportTaskStatuesResponse response = null;
        try {
            TaskMaster taskMaster = this.masterPool.get(request2.getJobInstanceId());
            if (taskMaster != null) {
                taskMaster.batchUpdateTaskStatus(request2);
            }
            response = Worker.ContainerBatchReportTaskStatuesResponse.newBuilder().setSuccess(true).setDeliveryId(request2.getDeliveryId()).build();
            this.getSender().tell(response, this.getSelf());
        }
        catch (Throwable e) {
            try {
                LOGGER.error("jobInstanceId={}, handleBatchTaskStatues error.", request2.getJobInstanceId(), e);
                response = Worker.ContainerBatchReportTaskStatuesResponse.newBuilder().setSuccess(false).setMessage(ExceptionUtil.getMessage(e)).setDeliveryId(request2.getDeliveryId()).build();
                this.getSender().tell(response, this.getSelf());
            }
            catch (Throwable throwable) {
                this.getSender().tell(response, this.getSelf());
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMapTask(Worker.WorkerMapTaskRequest request2) throws Exception {
        Worker.WorkerMapTaskResponse response = null;
        try {
            long jobInstanceId = request2.getJobInstanceId();
            TaskMaster taskMaster = this.masterPool.get(jobInstanceId);
            if (taskMaster != null) {
                if (!(taskMaster instanceof MapTaskMaster)) {
                    response = Worker.WorkerMapTaskResponse.newBuilder().setSuccess(false).setMessage("TaskMaster is not MapTaskMaster").build();
                    taskMaster.updateNewInstanceStatus(taskMaster.getSerialNum(), InstanceStatus.FAILED, "TaskMaster is not MapTaskMaster");
                } else {
                    try {
                        long startTime = System.currentTimeMillis();
                        boolean overload = ((MapTaskMaster)taskMaster).map(request2.getTaskBodyList(), request2.getTaskName());
                        LOGGER.debug("jobInstanceId={} map, cost={}ms", jobInstanceId, System.currentTimeMillis() - startTime);
                        response = Worker.WorkerMapTaskResponse.newBuilder().setSuccess(true).setOverload(overload).build();
                    }
                    catch (Exception e) {
                        LOGGER.error("jobInstanceId={} map error", e);
                        taskMaster.updateNewInstanceStatus(taskMaster.getSerialNum(), InstanceStatus.FAILED, ExceptionUtil.getMessage(e));
                        throw e;
                    }
                }
            } else {
                response = Worker.WorkerMapTaskResponse.newBuilder().setSuccess(false).setMessage("can't found TaskMaster by jobInstanceId=" + jobInstanceId).build();
            }
            this.getSender().tell(response, this.getSelf());
        }
        catch (Throwable e) {
            try {
                LOGGER.error("jobInstanceId={}, handleMapTask error.", request2.getJobInstanceId(), e);
                response = Worker.WorkerMapTaskResponse.newBuilder().setSuccess(false).setMessage(ExceptionUtil.getMessage(e)).build();
                this.getSender().tell(response, this.getSelf());
            }
            catch (Throwable throwable) {
                this.getSender().tell(response, this.getSelf());
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePullTasks(Worker.PullTaskFromMasterRequest request2) {
        long jobInstanceId = request2.getJobInstanceId();
        TaskMaster taskMaster = this.masterPool.get(jobInstanceId);
        Worker.PullTaskFromMasterResponse response = null;
        try {
            if (taskMaster == null || !(taskMaster instanceof MapTaskMaster)) {
                response = Worker.PullTaskFromMasterResponse.newBuilder().setSuccess(false).setMessage("TaskMaster is null or not MapTaskMaster, jobInstanceId=" + jobInstanceId).build();
            } else {
                List<Worker.MasterStartContainerRequest> reqs = ((MapTaskMaster)taskMaster).syncPullTasks(request2.getPageSize(), request2.getWorkerIdAddr());
                response = Worker.PullTaskFromMasterResponse.newBuilder().setSuccess(true).addAllRequest(reqs).build();
            }
            this.getSender().tell(response, this.getSelf());
        }
        catch (Throwable e) {
            try {
                LOGGER.error("", e);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.getSender().tell(response, this.getSelf());
            }
        }
    }
}

