/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.oio;

import com.alibaba.schedulerx.shade.org.jboss.netty.channel.Channel;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelException;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelFactory;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelPipeline;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelSink;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.Channels;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.oio.OioSocketChannel;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.Socket;
import java.net.SocketAddress;

class OioAcceptedSocketChannel
extends OioSocketChannel {
    private final PushbackInputStream in;
    private final OutputStream out;

    OioAcceptedSocketChannel(Channel parent, ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink, Socket socket) {
        super(parent, factory, pipeline, sink, socket);
        try {
            this.in = new PushbackInputStream(socket.getInputStream(), 1);
        }
        catch (IOException e) {
            throw new ChannelException("Failed to obtain an InputStream.", e);
        }
        try {
            this.out = socket.getOutputStream();
        }
        catch (IOException e) {
            throw new ChannelException("Failed to obtain an OutputStream.", e);
        }
        Channels.fireChannelOpen(this);
        Channels.fireChannelBound(this, (SocketAddress)this.getLocalAddress());
    }

    PushbackInputStream getInputStream() {
        return this.in;
    }

    OutputStream getOutputStream() {
        return this.out;
    }
}

