/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.apache.http.impl.execchain;

import com.alibaba.schedulerx.shade.org.apache.http.HttpException;
import com.alibaba.schedulerx.shade.org.apache.http.HttpResponse;
import com.alibaba.schedulerx.shade.org.apache.http.annotation.Contract;
import com.alibaba.schedulerx.shade.org.apache.http.annotation.ThreadingBehavior;
import com.alibaba.schedulerx.shade.org.apache.http.client.BackoffManager;
import com.alibaba.schedulerx.shade.org.apache.http.client.ConnectionBackoffStrategy;
import com.alibaba.schedulerx.shade.org.apache.http.client.methods.CloseableHttpResponse;
import com.alibaba.schedulerx.shade.org.apache.http.client.methods.HttpExecutionAware;
import com.alibaba.schedulerx.shade.org.apache.http.client.methods.HttpRequestWrapper;
import com.alibaba.schedulerx.shade.org.apache.http.client.protocol.HttpClientContext;
import com.alibaba.schedulerx.shade.org.apache.http.conn.routing.HttpRoute;
import com.alibaba.schedulerx.shade.org.apache.http.impl.execchain.ClientExecChain;
import com.alibaba.schedulerx.shade.org.apache.http.util.Args;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class BackoffStrategyExec
implements ClientExecChain {
    private final ClientExecChain requestExecutor;
    private final ConnectionBackoffStrategy connectionBackoffStrategy;
    private final BackoffManager backoffManager;

    public BackoffStrategyExec(ClientExecChain requestExecutor, ConnectionBackoffStrategy connectionBackoffStrategy, BackoffManager backoffManager) {
        Args.notNull(requestExecutor, "HTTP client request executor");
        Args.notNull(connectionBackoffStrategy, "Connection backoff strategy");
        Args.notNull(backoffManager, "Backoff manager");
        this.requestExecutor = requestExecutor;
        this.connectionBackoffStrategy = connectionBackoffStrategy;
        this.backoffManager = backoffManager;
    }

    @Override
    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request2, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        Args.notNull(route, "HTTP route");
        Args.notNull(request2, "HTTP request");
        Args.notNull(context, "HTTP context");
        Closeable out = null;
        try {
            out = this.requestExecutor.execute(route, request2, context, execAware);
        }
        catch (Exception ex) {
            if (out != null) {
                out.close();
            }
            if (this.connectionBackoffStrategy.shouldBackoff(ex)) {
                this.backoffManager.backOff(route);
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            if (ex instanceof HttpException) {
                throw (HttpException)ex;
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new UndeclaredThrowableException(ex);
        }
        if (this.connectionBackoffStrategy.shouldBackoff((HttpResponse)((Object)out))) {
            this.backoffManager.backOff(route);
        } else {
            this.backoffManager.probe(route);
        }
        return out;
    }
}

