/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.javassist.bytecode;

import com.alibaba.schedulerx.shade.javassist.bytecode.ConstInfo;
import com.alibaba.schedulerx.shade.javassist.bytecode.ConstPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;

class DoubleInfo
extends ConstInfo {
    static final int tag = 6;
    double value;

    public DoubleInfo(double d, int index2) {
        super(index2);
        this.value = d;
    }

    public DoubleInfo(DataInputStream in2, int index2) throws IOException {
        super(index2);
        this.value = in2.readDouble();
    }

    public int hashCode() {
        long v = Double.doubleToLongBits(this.value);
        return (int)(v ^ v >>> 32);
    }

    public boolean equals(Object obj) {
        return obj instanceof DoubleInfo && ((DoubleInfo)obj).value == this.value;
    }

    @Override
    public int getTag() {
        return 6;
    }

    @Override
    public int copy(ConstPool src, ConstPool dest, Map map2) {
        return dest.addDoubleInfo(this.value);
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeByte(6);
        out.writeDouble(this.value);
    }

    @Override
    public void print(PrintWriter out) {
        out.print("Double ");
        out.println(this.value);
    }
}

