/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.hsf.hessian.util;

public class IntMap {
    public static final int NULL = -559038737;
    private Object[] _keys;
    private int[] _values;
    private int _size;
    private int _prime;
    public static final int[] PRIMES = new int[]{1, 2, 3, 7, 13, 31, 61, 127, 251, 509, 1021, 2039, 4093, 8191, 16381, 32749, 65521, 131071, 262139, 524287, 1048573, 0x1FFFF7, 0x3FFFFD, 0x7FFFF1, 0xFFFFFD, 33554393, 0x3FFFFFB, 134217689, 0xFFFFFC7};

    public IntMap() {
        int capacity = 1024;
        this._keys = new Object[capacity];
        this._values = new int[capacity];
        this._prime = IntMap.getBiggestPrime(this._keys.length);
        this._size = 0;
    }

    public void clear() {
        Object[] keys = this._keys;
        int[] values2 = this._values;
        for (int i = keys.length - 1; i >= 0; --i) {
            keys[i] = null;
            values2[i] = 0;
        }
        this._size = 0;
    }

    public final int size() {
        return this._size;
    }

    public final int get(Object key) {
        int prime = this._prime;
        int hash2 = this.hashCode(key) % prime;
        Object[] keys = this._keys;
        Object mapKey;
        while ((mapKey = keys[hash2]) != null) {
            if (mapKey == key) {
                return this._values[hash2];
            }
            hash2 = (hash2 + 1) % prime;
        }
        return -559038737;
    }

    public final int put(Object key, int value2, boolean isReplace) {
        int prime = this._prime;
        int hash2 = this.hashCode(key) % prime;
        Object[] keys = this._keys;
        while (true) {
            Object testKey;
            if ((testKey = keys[hash2]) == null) {
                keys[hash2] = key;
                this._values[hash2] = value2;
                ++this._size;
                if (keys.length <= 4 * this._size) {
                    this.resize(4 * keys.length);
                }
                return -559038737;
            }
            if (key == testKey) break;
            hash2 = (hash2 + 1) % prime;
        }
        if (isReplace) {
            int old = this._values[hash2];
            this._values[hash2] = value2;
            return old;
        }
        return this._values[hash2];
    }

    private void resize(int newSize) {
        Object[] keys = this._keys;
        int[] values2 = this._values;
        this._keys = new Object[newSize];
        this._values = new int[newSize];
        this._size = 0;
        this._prime = IntMap.getBiggestPrime(this._keys.length);
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == null) continue;
            this.put(key, values2[i], true);
        }
    }

    protected int hashCode(Object value2) {
        return value2.hashCode();
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("IntMap[");
        boolean isFirst = true;
        for (int i = 0; i <= this._keys.length; ++i) {
            if (this._keys[i] == null) continue;
            if (!isFirst) {
                sbuf.append(", ");
            }
            isFirst = false;
            sbuf.append(this._keys[i]);
            sbuf.append(":");
            sbuf.append(this._values[i]);
        }
        sbuf.append("]");
        return sbuf.toString();
    }

    public static int getBiggestPrime(int value2) {
        for (int i = PRIMES.length - 1; i >= 0; --i) {
            if (PRIMES[i] > value2) continue;
            return PRIMES[i];
        }
        return 2;
    }
}

