/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.hsf.hessian.io;

import com.alibaba.schedulerx.shade.hsf.hessian.io.Hessian2Input;
import com.alibaba.schedulerx.shade.hsf.hessian.io.Hessian2Output;
import com.alibaba.schedulerx.shade.hsf.hessian.io.HessianEnvelope;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class Deflation
extends HessianEnvelope {
    @Override
    public Hessian2Output wrap(Hessian2Output out) throws IOException {
        DeflateOutputStream os = new DeflateOutputStream(out);
        Hessian2Output filterOut = new Hessian2Output(os);
        filterOut.setCloseStreamOnClose(true);
        return filterOut;
    }

    @Override
    public Hessian2Input unwrap(Hessian2Input in2) throws IOException {
        int version = in2.readEnvelope();
        String method = in2.readMethod();
        if (!method.equals(this.getClass().getName())) {
            throw new IOException("expected hessian Envelope method '" + this.getClass().getName() + "' at '" + method + "'");
        }
        return this.unwrapHeaders(in2);
    }

    @Override
    public Hessian2Input unwrapHeaders(Hessian2Input in2) throws IOException {
        DeflateInputStream is = new DeflateInputStream(in2);
        Hessian2Input filter2 = new Hessian2Input(is);
        filter2.setCloseStreamOnClose(true);
        return filter2;
    }

    static class DeflateInputStream
    extends InputStream {
        private Hessian2Input _in;
        private InputStream _bodyIn;
        private InflaterInputStream _inflateIn;

        DeflateInputStream(Hessian2Input in2) throws IOException {
            this._in = in2;
            int len2 = in2.readInt();
            if (len2 != 0) {
                throw new IOException("expected no headers");
            }
            this._bodyIn = this._in.readInputStream();
            this._inflateIn = new InflaterInputStream(this._bodyIn);
        }

        @Override
        public int read() throws IOException {
            return this._inflateIn.read();
        }

        @Override
        public int read(byte[] buffer, int offset, int length) throws IOException {
            return this._inflateIn.read(buffer, offset, length);
        }

        @Override
        public void close() throws IOException {
            Hessian2Input in2 = this._in;
            this._in = null;
            if (in2 != null) {
                this._inflateIn.close();
                this._bodyIn.close();
                int len2 = in2.readInt();
                if (len2 != 0) {
                    throw new IOException("Unexpected footer");
                }
                in2.completeEnvelope();
                in2.close();
            }
        }
    }

    static class DeflateOutputStream
    extends OutputStream {
        private Hessian2Output _out;
        private OutputStream _bodyOut;
        private DeflaterOutputStream _deflateOut;

        DeflateOutputStream(Hessian2Output out) throws IOException {
            this._out = out;
            this._out.startEnvelope(Deflation.class.getName());
            this._out.writeInt(0);
            this._bodyOut = this._out.getBytesOutputStream();
            this._deflateOut = new DeflaterOutputStream(this._bodyOut);
        }

        @Override
        public void write(int ch) throws IOException {
            this._deflateOut.write(ch);
        }

        @Override
        public void write(byte[] buffer, int offset, int length) throws IOException {
            this._deflateOut.write(buffer, offset, length);
        }

        @Override
        public void close() throws IOException {
            Hessian2Output out = this._out;
            this._out = null;
            if (out != null) {
                this._deflateOut.close();
                this._bodyOut.close();
                out.writeInt(0);
                out.completeEnvelope();
                out.close();
            }
        }
    }
}

