/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.taobao.spas.sdk.common.log;

import com.alibaba.schedulerx.shade.com.taobao.spas.sdk.common.log.SpasLogCode;
import com.alibaba.schedulerx.shade.com.taobao.spas.sdk.common.log.SpasLoggerFactory;
import com.taobao.middleware.logger.Logger;

public class SpasLogger {
    private static Logger logger = SpasLoggerFactory.getLogger(SpasLogger.class);

    public static void info(String s2) {
        logger.info(s2);
    }

    public static void info(String appName, String s2) {
        logger.info(SpasLogger.formatAppName(appName), s2);
    }

    public static void warn(String s2) {
        logger.warn(s2);
    }

    public static void warn(String appName, String s2) {
        logger.warn(SpasLogger.formatAppName(appName), s2);
    }

    public static void error(String s2) {
        logger.error("", s2);
    }

    public static void error(String appName, String s2) {
        logger.error(SpasLogger.formatAppName(appName), "", s2);
    }

    public static void error(String s2, Throwable throwable) {
        logger.error("", s2, throwable);
    }

    public static void error(String appName, String s2, Throwable throwable) {
        logger.error(SpasLogger.formatAppName(appName), "", s2, throwable);
    }

    public static void info(SpasLogCode code, String s2) {
        logger.info(SpasLogger.formatLogMessage(code, s2));
    }

    public static void info(SpasLogCode code, String appName, String s2) {
        logger.info(SpasLogger.formatAppName(appName), SpasLogger.formatLogMessage(code, s2));
    }

    public static void warn(SpasLogCode code, String s2) {
        logger.warn(SpasLogger.formatLogMessage(code, s2));
    }

    public static void warn(SpasLogCode code, String appName, String s2) {
        logger.warn(SpasLogger.formatAppName(appName), SpasLogger.formatLogMessage(code, s2));
    }

    public static void error(SpasLogCode code, String s2) {
        logger.error("", SpasLogger.formatLogMessage(code, s2));
    }

    public static void error(SpasLogCode code, String appName, String s2) {
        logger.error(SpasLogger.formatAppName(appName), "", SpasLogger.formatLogMessage(code, s2));
    }

    public static void error(SpasLogCode code, String s2, Throwable throwable) {
        logger.error("", SpasLogger.formatLogMessage(code, s2), throwable);
    }

    public static void error(SpasLogCode code, String appName, String s2, Throwable throwable) {
        logger.error(SpasLogger.formatAppName(appName), "", SpasLogger.formatLogMessage(code, s2), throwable);
    }

    private static String formatAppName(String appName) {
        return appName == null ? "" : appName;
    }

    private static String formatLogMessage(SpasLogCode code, String s2) {
        return String.format("[SPAS-%04d] %s", code.getValue(), s2);
    }
}

