/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.taobao.spas.sdk.common.config;

import com.alibaba.schedulerx.shade.com.taobao.spas.sdk.common.log.SpasLogCode;
import com.alibaba.schedulerx.shade.com.taobao.spas.sdk.common.log.SpasLogger;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class SpasConfigLoader {
    private static final String CONFIG_PATH = "/home/admin/spas_conf/global";
    private static final String APP_CONFIG_FORMAT = "spas_app_config_%s.%s";
    private static Map<String, String> properties = new ConcurrentHashMap<String, String>();
    private static ConcurrentHashMap<String, Map<String, String>> appProperties = new ConcurrentHashMap();

    public static void init() {
    }

    public static String getProperty(String key) {
        String value2 = properties.get(key);
        if (value2 == null && (value2 = System.getProperty(key)) != null) {
            properties.put(key, value2);
        }
        return value2;
    }

    public static String getProperty(String key, String def) {
        String value2 = SpasConfigLoader.getProperty(key);
        return value2 != null ? value2 : def;
    }

    public static String getAppProperty(String appName, String key) {
        String value2;
        if (appName == null) {
            return SpasConfigLoader.getProperty(key);
        }
        Map<String, String> props2 = appProperties.get(appName);
        String string2 = value2 = props2 != null ? props2.get(key) : null;
        if (value2 == null) {
            value2 = System.getProperty(String.format(APP_CONFIG_FORMAT, appName, key));
            if (value2 != null) {
                SpasConfigLoader.setAppProperty(appName, key, value2);
            } else {
                value2 = SpasConfigLoader.getProperty(key);
            }
        }
        return value2;
    }

    public static String getAppProperty(String appName, String key, String def) {
        String value2 = SpasConfigLoader.getAppProperty(appName, key);
        return value2 != null ? value2 : def;
    }

    public static void setProperty(String key, String value2) {
        properties.put(key, value2);
    }

    public static void setAppProperty(String appName, String key, String value2) {
        Map<String, String> old;
        Map<String, String> props2 = appProperties.get(appName);
        if (props2 == null && (old = appProperties.putIfAbsent(appName, props2 = new ConcurrentHashMap<String, String>())) != null) {
            props2 = old;
        }
        props2.put(key, value2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        boolean disabled = "Y".equalsIgnoreCase(System.getProperty("spas.config.disable"));
        if (!disabled) {
            Properties properties = new Properties();
            FileInputStream globalConfigIS = null;
            try {
                globalConfigIS = new FileInputStream(CONFIG_PATH);
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
            if (globalConfigIS != null) {
                try {
                    properties.load(globalConfigIS);
                }
                catch (IOException e) {
                    SpasLogger.error(SpasLogCode.SPAS0105, "Unable to load properties from /home/admin/spas_conf/global:" + e.getMessage());
                }
                finally {
                    try {
                        globalConfigIS.close();
                    }
                    catch (IOException e) {}
                }
            }
            for (Map.Entry<Object, Object> property : properties.entrySet()) {
                Properties currentProperties = System.getProperties();
                Object old = currentProperties.get(property.getKey());
                if (old != null) continue;
                System.setProperty(property.getKey().toString(), property.getValue().toString());
                SpasLogger.info("Set property " + property.getKey() + "=" + property.getValue());
            }
        }
    }
}

