/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.aliyun.openservices.log.sample;

import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.Client;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.Consts;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.Histogram;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.LogContent;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.LogItem;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.QueriedLog;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.exception.LogException;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.request.PullLogsRequest;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.response.GetHistogramsResponse;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.response.GetLogsResponse;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.response.ListTopicsResponse;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.response.PullLogsResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;

public class SlsSample {
    public static void main(String[] args) throws LogException, InterruptedException {
        int to2;
        int from2;
        String query;
        String accessId = "your_access_id";
        String accessKey = "your_access_key";
        String project = "your_project_name";
        String host = "";
        String logStore = "your_logstore";
        String topic = "TestTopic_2";
        int shardId = 0;
        Client client = new Client(host, accessId, accessKey);
        String cursor = client.GetCursor(project, logStore, shardId, Consts.CursorMode.END).GetCursor();
        System.out.println("cursor = " + cursor);
        try {
            while (true) {
                PullLogsRequest request2 = new PullLogsRequest(project, logStore, shardId, 1000, cursor);
                PullLogsResponse response = client.pullLogs(request2);
                System.out.println(response.getCount());
                System.out.println("cursor = " + cursor + " next_cursor = " + response.getNextCursor());
                if (!cursor.equals(response.getNextCursor())) {
                    cursor = response.getNextCursor();
                    Thread.sleep(200L);
                    continue;
                }
                break;
            }
        }
        catch (LogException e) {
            System.out.println(e.GetRequestId() + e.GetErrorMessage());
        }
        if (shardId > 0) {
            return;
        }
        int from_t = (int)(new Date().getTime() / 1000L) - 36000;
        int to_t = (int)(new Date().getTime() / 1000L) - 100;
        GetLogsResponse res = client.GetLogs(project, logStore, from_t, to_t, topic, "", 10, 0, false);
        System.out.println("Returned log data count:" + res.GetCount());
        for (QueriedLog log2 : res.GetLogs()) {
            System.out.println("source : " + log2.GetSource());
            LogItem item = log2.GetLogItem();
            System.out.println("time : " + item.mLogTime);
            for (LogContent content : item.mContents) {
                System.out.println(content.mKey + ":" + content.mValue);
            }
        }
        int log_group_num = 10;
        for (int i = 0; i < log_group_num; ++i) {
            Vector<LogItem> logGroup = new Vector<LogItem>();
            LogItem logItem = new LogItem((int)(new Date().getTime() / 1000L));
            logItem.PushBack("level", "info");
            logItem.PushBack("name", String.valueOf(i));
            logItem.PushBack("message", "it's a test message");
            logGroup.add(logItem);
            LogItem logItem2 = new LogItem((int)(new Date().getTime() / 1000L));
            logItem2.PushBack("level", "error");
            logItem2.PushBack("name", String.valueOf(i));
            logItem2.PushBack("message", "it's a test message");
            logGroup.add(logItem2);
            try {
                client.PutLogs(project, logStore, topic, logGroup, "");
                continue;
            }
            catch (LogException e) {
                System.out.println("error code :" + e.GetErrorCode());
                System.out.println("error message :" + e.GetErrorMessage());
                System.out.println("error requestId :" + e.GetRequestId());
                throw e;
            }
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        try {
            ArrayList<String> logStores = client.ListLogStores(project, 0, 500, "").GetLogStores();
            System.out.println("ListLogs:" + logStores.toString() + "\n");
        }
        catch (LogException e) {
            System.out.print(e.getCause());
            System.out.println("error code :" + e.GetErrorCode());
            System.out.println("error message :" + e.GetErrorMessage());
            System.out.println("error requestId :" + e.GetRequestId());
            throw e;
        }
        try {
            String token2 = "";
            ListTopicsResponse listTopicResponse = client.ListTopics(project, logStore, token2, 10);
            ArrayList<String> topics = listTopicResponse.GetTopics();
            System.out.println("ListTopics:" + topics.toString());
            System.out.println("NextTopic:" + listTopicResponse.GetNextToken() + "\n");
        }
        catch (LogException e) {
            System.out.println("error code :" + e.GetErrorCode());
            System.out.println("error message :" + e.GetErrorMessage());
            System.out.println("error requestId :" + e.GetRequestId());
            throw e;
        }
        try {
            query = "";
            from2 = (int)(new Date().getTime() / 1000L - 10000L);
            to2 = (int)(new Date().getTime() / 1000L + 10L);
            GetHistogramsResponse histogramsResponse = client.GetHistograms(project, logStore, from2, to2, topic, query);
            System.out.println("histogram result: " + histogramsResponse.GetTotalCount());
            System.out.println("is_completed : " + histogramsResponse.IsCompleted());
            for (Histogram histogram : histogramsResponse.GetHistograms()) {
                System.out.println("beginTime:" + histogram.mFromTime + " endTime:" + histogram.mToTime + " logCount:" + histogram.mCount + " is_completed:" + histogram.mIsCompleted);
            }
            System.out.println("");
        }
        catch (LogException e) {
            System.out.println("error code :" + e.GetErrorCode());
            System.out.println("error message :" + e.GetErrorMessage());
            System.out.println("error requestId :" + e.GetRequestId());
            throw e;
        }
        try {
            query = "error";
            from2 = (int)(new Date().getTime() / 1000L - 10000L);
            to2 = (int)(new Date().getTime() / 1000L + 10L);
            GetLogsResponse logsResponse = client.GetLogs(project, logStore, from2, to2, topic, query, 10, 0, false);
            System.out.println("Returned log data count:" + logsResponse.GetCount());
            for (QueriedLog log3 : logsResponse.GetLogs()) {
                System.out.println("source : " + log3.GetSource());
                LogItem item = log3.GetLogItem();
                System.out.println("time : " + item.mLogTime);
                for (LogContent content : item.mContents) {
                    System.out.println(content.mKey + ":" + content.mValue);
                }
            }
        }
        catch (LogException e) {
            System.out.println("error code :" + e.GetErrorCode());
            System.out.println("error message :" + e.GetErrorMessage());
            throw e;
        }
    }
}

