/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common;

import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.util.VarintUtil;
import java.io.UnsupportedEncodingException;

public class FastLogContent {
    private byte[] rawBytes;
    private int beginOffset;
    private int endOffset;
    private int keyOffset = -1;
    private int keyLength = -1;
    private int valueOffset = -1;
    private int valueLength = -1;

    public FastLogContent(byte[] rawBytes, int offset, int length) {
        this.rawBytes = rawBytes;
        this.beginOffset = offset;
        this.endOffset = offset + length;
        if (!this.parse()) {
            this.keyOffset = -1;
            this.keyLength = -1;
            this.valueOffset = -1;
            this.valueLength = -1;
        }
    }

    private boolean parse() {
        int pos = this.beginOffset;
        while (pos < this.endOffset) {
            int[] value2 = VarintUtil.DecodeVarInt32(this.rawBytes, pos, this.endOffset);
            if (value2[0] == 0) {
                return false;
            }
            int mode = value2[1] & 7;
            int index2 = value2[1] >> 3;
            pos = value2[2];
            if (mode == 0) {
                value2 = VarintUtil.DecodeVarInt32(this.rawBytes, pos, this.endOffset);
                if (value2[0] == 0) {
                    return false;
                }
                pos = value2[2];
                continue;
            }
            if (mode == 1) {
                pos += 8;
                continue;
            }
            if (mode == 2) {
                value2 = VarintUtil.DecodeVarInt32(this.rawBytes, pos, this.endOffset);
                if (value2[0] == 0) {
                    return false;
                }
                pos = value2[2] + value2[1];
                if (index2 == 1) {
                    this.keyOffset = value2[2];
                    this.keyLength = value2[1];
                    continue;
                }
                if (index2 != 2) continue;
                this.valueOffset = value2[2];
                this.valueLength = value2[1];
                continue;
            }
            if (mode == 5) {
                pos += 4;
                continue;
            }
            return false;
        }
        return this.keyOffset != -1 && this.valueOffset != -1 && pos == this.endOffset;
    }

    public String getKey() {
        return this.decodeString(this.keyOffset, this.keyLength);
    }

    public String getKey(String charset) throws UnsupportedEncodingException {
        return this.decodeString(this.keyOffset, this.keyLength, charset);
    }

    public String getValue() {
        return this.decodeString(this.valueOffset, this.valueLength);
    }

    public String getValue(String charset) throws UnsupportedEncodingException {
        return this.decodeString(this.valueOffset, this.valueLength, charset);
    }

    private String decodeString(int offset, int length) {
        return offset < 0 ? null : new String(this.rawBytes, offset, length);
    }

    private String decodeString(int offset, int length, String charset) throws UnsupportedEncodingException {
        return offset < 0 ? null : new String(this.rawBytes, offset, length, charset);
    }

    public byte[] getKeyBytes() {
        return this.cutBytes(this.keyOffset, this.keyLength);
    }

    public byte[] getValueBytes() {
        return this.cutBytes(this.valueOffset, this.valueLength);
    }

    private byte[] cutBytes(int offset, int length) {
        if (offset < 0) {
            return null;
        }
        byte[] bytes = new byte[length];
        System.arraycopy(this.rawBytes, offset, bytes, 0, length);
        return bytes;
    }
}

