/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.aliyun.openservices.aliyun.log.producer.internals;

import com.alibaba.schedulerx.shade.com.aliyun.openservices.aliyun.log.producer.internals.LogThread;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.aliyun.log.producer.internals.ProducerBatch;
import com.alibaba.schedulerx.shade.org.slf4j.Logger;
import com.alibaba.schedulerx.shade.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;

public class BatchHandler
extends LogThread {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchHandler.class);
    private final BlockingQueue<ProducerBatch> batches;
    private final AtomicInteger batchCount;
    private final Semaphore memoryController;
    private volatile boolean closed;

    public BatchHandler(String name, BlockingQueue<ProducerBatch> batches, AtomicInteger batchCount, Semaphore memoryController) {
        super(name, true);
        this.batches = batches;
        this.batchCount = batchCount;
        this.memoryController = memoryController;
        this.closed = false;
    }

    @Override
    public void run() {
        this.loopHandleBatches();
        this.handleRemainingBatches();
    }

    private void loopHandleBatches() {
        while (!this.closed) {
            try {
                ProducerBatch b = this.batches.take();
                this.handle(b);
            }
            catch (InterruptedException e) {
                LOGGER.info("The batch handler has been interrupted");
            }
        }
    }

    private void handleRemainingBatches() {
        ArrayList remainingBatches = new ArrayList();
        this.batches.drainTo(remainingBatches);
        for (ProducerBatch b : remainingBatches) {
            this.handle(b);
        }
    }

    private void handle(ProducerBatch batch2) {
        try {
            batch2.fireCallbacksAndSetFutures();
        }
        catch (Throwable t) {
            LOGGER.error("Failed to handle batch, batch={}, e=", (Object)batch2, (Object)t);
        }
        finally {
            this.batchCount.decrementAndGet();
            this.memoryController.release(batch2.getCurBatchSizeInBytes());
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        this.closed = true;
        this.interrupt();
    }
}

