package com.alibaba.schedulerx.worker.util;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.mashape.unirest.http.ObjectMapper;
import com.mashape.unirest.http.Unirest;

/**
 * @author yanxun on 2018/12/11.
 */
public class UnirestUtil {
    /**
     * for object mapping, copy from unirest website(http://unirest.io/java.html)
     */
    public static void initUnirest() {
        Unirest.setObjectMapper(new ObjectMapper() {
            private com.fasterxml.jackson.databind.ObjectMapper jacksonObjectMapper
                = new com.fasterxml.jackson.databind.ObjectMapper();
            
            @Override
            public <T> T readValue(String value, Class<T> valueType) {
                try {
                    return jacksonObjectMapper.readValue(value, valueType);
                } catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            
            @Override
            public String writeValue(Object value) {
                try {
                    return jacksonObjectMapper.writeValueAsString(value);
                } catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }
}
