package com.alibaba.schedulerx.worker.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;

import com.alibaba.schedulerx.common.MyClassLoader;
import com.alibaba.schedulerx.common.util.JsonUtil;
import com.alibaba.schedulerx.common.util.ReflectionUtil;
import com.alibaba.schedulerx.worker.SchedulerxWorker;
import com.alibaba.schedulerx.worker.domain.JavaProcessorProfile;
import com.alibaba.schedulerx.worker.processor.JavaProcessor;
import com.alibaba.schedulerx.worker.processor.JobProcessor;

/**
 *
 * @author xiaomeng.hxm
 */
public class JavaProcessorProfileUtil {

    public static JobProcessor getJavaProcessor(String content) throws Exception {
        JobProcessor jobProcessor;
        JavaProcessorProfile profile = JsonUtil.fromJson(content, JavaProcessorProfile.class);
        //如果没有配置jarUrl，表示用户和用户应用在同一个进程中，直接从当前进程中获取
        if (profile.getJarUrl() == null || profile.getJarUrl().isEmpty()) {
            if (SpringContext.context != null) {
                jobProcessor = SpringContext.getBean(profile.getClassName(), SchedulerxWorker.CUSTOMER_CLASS_LOADER);
            } else {
                jobProcessor = ReflectionUtil.getInstanceByClassName(profile.getClassName(), SchedulerxWorker.CUSTOMER_CLASS_LOADER);
            }
        } else {
            String jarUrl = profile.getJarUrl();
            String jarFilePath = jarUrl;
            @SuppressWarnings("resource")
            MyClassLoader classLoader = new MyClassLoader(new URL[] {}, Thread.currentThread()
                .getContextClassLoader());
            if (jarUrl.startsWith("file:")) {
                // jar包存在本地
                jarFilePath = jarUrl.substring("file:".length());
            } else if (jarUrl.startsWith("http:")) {
                // 这里目前主要是支持oss上传
                jarFilePath = FileDownloader.httpDownload(jarUrl);
            } else if (jarUrl.startsWith("hdfs:")) {
                //TODO 比如可以把jar包上传到hdfs上
            }

            File jarFile = new File(jarFilePath);
            if (!jarFile.exists()) {
                throw new IOException(jarFilePath + "is not existed!");
            }
            classLoader.addJar(jarFile.toURI().toURL());
            if (SpringContext.context != null) {
                jobProcessor = SpringContext.getBean(profile.getClassName(), classLoader);
            } else {
                Class<?> clazz = classLoader.loadClass(profile.getClassName());
                jobProcessor = (JavaProcessor)ReflectionUtil.newInstanceWithoutCache(clazz);
            }
        }
        return jobProcessor;
    }
}
