package com.alibaba.schedulerx.worker.util;

import com.alibaba.schedulerx.common.domain.Constants;
import com.alibaba.schedulerx.worker.domain.WorkerConstants;

import org.apache.commons.lang.StringUtils;

/**
 * @author yanxun on 2019/1/9.
 */
public class ActorPathUtil {

    /**
     * get remote path of container router
     * @param workerIdAddr remote worker id and addr
     * @return remote worker container router path.
     */
    public static String getContainerRouterPath(String workerIdAddr) {
        return Constants.WORKER_AKKA_PATH_PREFIX + workerIdAddr
            + WorkerConstants.WORKER_AKKA_CONTAINER_ROUTING_PATH;
    }

    /**
     * get remote path of heartbeat router
     * @param workerIdAddr remote worker id and addr
     * @return remote worker heartbeat router path.
     */
    public static String getWorkerHeartbeatRouterPath(String workerIdAddr) {
        return Constants.WORKER_AKKA_PATH_PREFIX + workerIdAddr
            + WorkerConstants.WORKER_AKKA_HEARTBEAT_ROUTING_PATH;
    }

    public static String getWorkerJobInstancePath(String workerIdAddr) {
        return Constants.WORKER_AKKA_PATH_PREFIX + workerIdAddr
            + WorkerConstants.WORKER_AKKA_JOB_INSTANCE_ROUTING_PATH;
    }

    /**
     * get ip and port from akka path
     * @param akkaPath akka path string
     * @return ip and port, if akkaPath is empty, return ""
     */
    public static String getIpAndPortFromAkkaPath(String akkaPath) {
        if (StringUtils.isBlank(akkaPath)) {
            return "";
        }

        String subStr = akkaPath;
        int index = subStr.indexOf("@");
        if (index > 0) {
            subStr = subStr.substring(index + 1);
        }

        index = subStr.indexOf("/");
        if (index > 0) {
            subStr = subStr.substring(0, index);
        }

        return subStr;
    }
}
