package com.alibaba.schedulerx.worker.pull;

import java.io.IOException;

import com.alibaba.schedulerx.protocol.Worker.MasterStartContainerRequest;
import com.alibaba.schedulerx.worker.SchedulerxWorker;
import com.alibaba.schedulerx.worker.container.ContainerPool;
import com.alibaba.schedulerx.worker.container.ThreadContainer;
import com.alibaba.schedulerx.worker.domain.JobContext;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.util.ContanerUtil;

/**
 *
 * @author xiaomeng.hxm
 */
public class ConsumerThread extends ThreadContainer {

    private volatile boolean running = true;
    private BlockingContainerQueue queue;
    private static Logger LOGGER = LogFactory.getLogger(ConsumerThread.class);

    public ConsumerThread(JobContext context, ContainerPool containerPool) throws Exception {
        super(context, containerPool);
    }

    public ConsumerThread(BlockingContainerQueue queue, ContainerPool containerPool, String taskMasterAkkaPath) throws Exception {
        this.queue = queue;
        this.containerPool = containerPool;
        this.masterActorSelection = SchedulerxWorker.actorSystem.actorSelection(taskMasterAkkaPath);
        if (masterActorSelection == null) {
            String errMsg = "get taskMaster akka path error, path=" + taskMasterAkkaPath;
            LOGGER.error(errMsg);
            throw new IOException(errMsg);
        }
    }


    @Override
    public void run() {
        while (running) {
            try {
                MasterStartContainerRequest request = queue.get();
                if (request != null) {
                    JobContext context = ContanerUtil.convert2JobContext(request);
                    setContext(context);
                    containerPool.put(context.getUniqueId(), this);
                    super.start();
                }
            } catch (Exception e) {
                LOGGER.error("", e);
            }
        }
    }

    public void stopRunning() {
        running = false;
    }

}
