package com.alibaba.schedulerx.worker.processor.demo;

import com.alibaba.schedulerx.worker.domain.JobContext;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.processor.JavaProcessor;
import com.alibaba.schedulerx.worker.processor.ProcessResult;

import org.springframework.stereotype.Component;

/**
 *
 * @author xiaomeng.hxm
 */
@Component
public class TestSimpleJobProcessorWithKill extends JavaProcessor {
    private static final Logger LOGGER = LogFactory.getLogger(TestSimpleJobProcessorWithKill.class);
    private volatile boolean stop = false;

    @Override
    public ProcessResult process(JobContext context) throws Exception {
        LOGGER.info("Hello SchedulerX2.0! This is [TestSimpleJobProcessorWithKill]");
        System.out.println("jobParameters=" + context.getJobParameters() + ", instanceParameters="
                + context.getInstanceParameters());

        int N = 10000;
        while (!stop && N >= 0) {
            System.out.println("do something...");
            Thread.sleep(1000);
            N--;
        }
        return new ProcessResult(true);
    }

    @Override
    public void kill(JobContext context) {
        stop = true;
    }

    @Override
    public void preProcess(JobContext context) {
        stop = false;
    }

}
