package com.alibaba.schedulerx.worker.processor.demo;

import com.alibaba.schedulerx.worker.domain.JobContext;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.processor.JavaProcessor;
import com.alibaba.schedulerx.worker.processor.ProcessResult;

import org.springframework.stereotype.Component;

@Component
public class TestShardingJob extends JavaProcessor {
    private static final Logger LOGGER = LogFactory.getLogger("data");

    @Override
    public ProcessResult process(JobContext context) throws Exception {
        LOGGER.info("分片id:" + context.getShardingId() + ", 分片参数:" + context.getShardingParameter());
        return new ProcessResult(true);
    }

}
