package com.alibaba.schedulerx.worker.processor.demo;


import com.alibaba.schedulerx.worker.domain.JobContext;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.processor.JavaProcessor;
import com.alibaba.schedulerx.worker.processor.ProcessResult;

import org.joda.time.DateTime;
import org.springframework.stereotype.Component;


@Component
public class CurrentTimeJob extends JavaProcessor {
    private static final Logger LOGGER = LogFactory.getLogger("data");

    @Override
    public ProcessResult process(JobContext context) throws Exception {
        LOGGER.info("currentTime=" + DateTime.now().toString("yyyy-MM-dd HH:mm:ss"));
        LOGGER.info("currentTime=" + DateTime.now().toDate());
        Thread.sleep(5000);
        return new ProcessResult(true);
    }
    
}
